/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.btree.dataflow;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.storage.am.btree.impls.RangePredicate;
import edu.uci.ics.hyracks.storage.am.btree.util.BTreeUtils;
import edu.uci.ics.hyracks.storage.am.common.api.ISearchPredicate;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndex;
import edu.uci.ics.hyracks.storage.am.common.dataflow.AbstractTreeIndexOperatorDescriptor;
import edu.uci.ics.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import edu.uci.ics.hyracks.storage.am.common.dataflow.IndexSearchOperatorNodePushable;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.MultiComparator;
import edu.uci.ics.hyracks.storage.am.common.tuples.PermutingFrameTupleReference;

public class BTreeSearchOperatorNodePushable
extends IndexSearchOperatorNodePushable {
    protected final boolean lowKeyInclusive;
    protected final boolean highKeyInclusive;
    protected PermutingFrameTupleReference lowKey;
    protected PermutingFrameTupleReference highKey;
    protected MultiComparator lowKeySearchCmp;
    protected MultiComparator highKeySearchCmp;

    public BTreeSearchOperatorNodePushable(AbstractTreeIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, IRecordDescriptorProvider recordDescProvider, int[] lowKeyFields, int[] highKeyFields, boolean lowKeyInclusive, boolean highKeyInclusive) {
        super((IIndexOperatorDescriptor)opDesc, ctx, partition, recordDescProvider);
        this.lowKeyInclusive = lowKeyInclusive;
        this.highKeyInclusive = highKeyInclusive;
        if (lowKeyFields != null && lowKeyFields.length > 0) {
            this.lowKey = new PermutingFrameTupleReference();
            this.lowKey.setFieldPermutation(lowKeyFields);
        }
        if (highKeyFields != null && highKeyFields.length > 0) {
            this.highKey = new PermutingFrameTupleReference();
            this.highKey.setFieldPermutation(highKeyFields);
        }
    }

    protected void resetSearchPredicate(int tupleIndex) {
        if (this.lowKey != null) {
            this.lowKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
        if (this.highKey != null) {
            this.highKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
    }

    protected ISearchPredicate createSearchPredicate() {
        ITreeIndex treeIndex = (ITreeIndex)this.index;
        this.lowKeySearchCmp = BTreeUtils.getSearchMultiComparator(treeIndex.getComparatorFactories(), (ITupleReference)this.lowKey);
        this.highKeySearchCmp = BTreeUtils.getSearchMultiComparator(treeIndex.getComparatorFactories(), (ITupleReference)this.highKey);
        return new RangePredicate((ITupleReference)this.lowKey, (ITupleReference)this.highKey, this.lowKeyInclusive, this.highKeyInclusive, this.lowKeySearchCmp, this.highKeySearchCmp);
    }
}

