/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.work;

import edu.uci.ics.hyracks.api.application.IApplicationContext;
import edu.uci.ics.hyracks.api.application.INCApplicationContext;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.comm.IPartitionCollector;
import edu.uci.ics.hyracks.api.comm.IPartitionWriterFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.ConnectorDescriptorId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IConnectorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.TaskAttemptId;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.connectors.IConnectorPolicy;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.ActivityCluster;
import edu.uci.ics.hyracks.api.job.ActivityClusterGraph;
import edu.uci.ics.hyracks.api.job.JobFlag;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.control.common.deployment.DeploymentUtils;
import edu.uci.ics.hyracks.control.common.job.TaskAttemptDescriptor;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import edu.uci.ics.hyracks.control.nc.Joblet;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import edu.uci.ics.hyracks.control.nc.Task;
import edu.uci.ics.hyracks.control.nc.application.NCApplicationContext;
import edu.uci.ics.hyracks.control.nc.partitions.MaterializedPartitionWriter;
import edu.uci.ics.hyracks.control.nc.partitions.MaterializingPipelinedPartition;
import edu.uci.ics.hyracks.control.nc.partitions.PipelinedPartition;
import edu.uci.ics.hyracks.control.nc.partitions.ReceiveSideMaterializingCollector;
import edu.uci.ics.hyracks.control.nc.profiling.ProfilingPartitionWriterFactory;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StartTasksWork
extends AbstractWork {
    private static final Logger LOGGER = Logger.getLogger(StartTasksWork.class.getName());
    private final NodeControllerService ncs;
    private final DeploymentId deploymentId;
    private final JobId jobId;
    private final byte[] acgBytes;
    private final List<TaskAttemptDescriptor> taskDescriptors;
    private final Map<ConnectorDescriptorId, IConnectorPolicy> connectorPoliciesMap;
    private final EnumSet<JobFlag> flags;

    public StartTasksWork(NodeControllerService ncs, DeploymentId deploymentId, JobId jobId, byte[] acgBytes, List<TaskAttemptDescriptor> taskDescriptors, Map<ConnectorDescriptorId, IConnectorPolicy> connectorPoliciesMap, EnumSet<JobFlag> flags) {
        this.ncs = ncs;
        this.deploymentId = deploymentId;
        this.jobId = jobId;
        this.acgBytes = acgBytes;
        this.taskDescriptors = taskDescriptors;
        this.connectorPoliciesMap = connectorPoliciesMap;
        this.flags = flags;
    }

    public void run() {
        try {
            NCApplicationContext appCtx = this.ncs.getApplicationContext();
            Joblet joblet = this.getOrCreateLocalJoblet(this.deploymentId, this.jobId, appCtx, this.acgBytes == null ? null : (ActivityClusterGraph)DeploymentUtils.deserialize((byte[])this.acgBytes, (DeploymentId)this.deploymentId, (IApplicationContext)appCtx));
            final ActivityClusterGraph acg = joblet.getActivityClusterGraph();
            IRecordDescriptorProvider rdp = new IRecordDescriptorProvider(){

                public RecordDescriptor getOutputRecordDescriptor(ActivityId aid, int outputIndex) {
                    ActivityCluster ac = (ActivityCluster)acg.getActivityMap().get(aid);
                    IConnectorDescriptor conn = (IConnectorDescriptor)((List)ac.getActivityOutputMap().get(aid)).get(outputIndex);
                    return (RecordDescriptor)ac.getConnectorRecordDescriptorMap().get(conn.getConnectorId());
                }

                public RecordDescriptor getInputRecordDescriptor(ActivityId aid, int inputIndex) {
                    ActivityCluster ac = (ActivityCluster)acg.getActivityMap().get(aid);
                    IConnectorDescriptor conn = (IConnectorDescriptor)((List)ac.getActivityInputMap().get(aid)).get(inputIndex);
                    return (RecordDescriptor)ac.getConnectorRecordDescriptorMap().get(conn.getConnectorId());
                }
            };
            for (TaskAttemptDescriptor td : this.taskDescriptors) {
                List outputs;
                RecordDescriptor recordDesc;
                TaskAttemptId taId = td.getTaskAttemptId();
                TaskId tid = taId.getTaskId();
                ActivityId aid = tid.getActivityId();
                ActivityCluster ac = (ActivityCluster)acg.getActivityMap().get(aid);
                IActivity han = (IActivity)ac.getActivityMap().get(aid);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Initializing " + taId + " -> " + han);
                }
                int partition = tid.getPartition();
                Task task = new Task(joblet, taId, han.getClass().getName(), this.ncs.getExecutor(), this.ncs);
                IOperatorNodePushable operator = han.createPushRuntime((IHyracksTaskContext)task, rdp, partition, td.getPartitionCount());
                ArrayList<IPartitionCollector> collectors = new ArrayList<IPartitionCollector>();
                List inputs = (List)ac.getActivityInputMap().get(aid);
                if (inputs != null) {
                    for (int i = 0; i < inputs.size(); ++i) {
                        IConnectorDescriptor conn = (IConnectorDescriptor)inputs.get(i);
                        IConnectorPolicy cPolicy = this.connectorPoliciesMap.get(conn.getConnectorId());
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("input: " + i + ": " + conn.getConnectorId());
                        }
                        recordDesc = (RecordDescriptor)ac.getConnectorRecordDescriptorMap().get(conn.getConnectorId());
                        IPartitionCollector collector = this.createPartitionCollector(td, partition, task, i, conn, recordDesc, cPolicy);
                        collectors.add(collector);
                    }
                }
                if ((outputs = (List)ac.getActivityOutputMap().get(aid)) != null) {
                    for (int i = 0; i < outputs.size(); ++i) {
                        IConnectorDescriptor conn = (IConnectorDescriptor)outputs.get(i);
                        recordDesc = (RecordDescriptor)ac.getConnectorRecordDescriptorMap().get(conn.getConnectorId());
                        IConnectorPolicy cPolicy = this.connectorPoliciesMap.get(conn.getConnectorId());
                        IPartitionWriterFactory pwFactory = this.createPartitionWriterFactory(task, cPolicy, this.jobId, conn, partition, taId, this.flags);
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("output: " + i + ": " + conn.getConnectorId());
                        }
                        IFrameWriter writer = conn.createPartitioner((IHyracksTaskContext)task, recordDesc, pwFactory, partition, td.getPartitionCount(), td.getOutputPartitionCounts()[i]);
                        operator.setOutputFrameWriter(i, writer, recordDesc);
                    }
                }
                task.setTaskRuntime(collectors.toArray(new IPartitionCollector[collectors.size()]), operator);
                joblet.addTask(task);
                task.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private Joblet getOrCreateLocalJoblet(DeploymentId deploymentId, JobId jobId, INCApplicationContext appCtx, ActivityClusterGraph acg) throws Exception {
        Map<JobId, Joblet> jobletMap = this.ncs.getJobletMap();
        Joblet ji = jobletMap.get(jobId);
        if (ji == null) {
            if (acg == null) {
                throw new NullPointerException("JobActivityGraph was null");
            }
            ji = new Joblet(this.ncs, deploymentId, jobId, appCtx, acg);
            jobletMap.put(jobId, ji);
        }
        return ji;
    }

    private IPartitionCollector createPartitionCollector(TaskAttemptDescriptor td, int partition, Task task, int i, IConnectorDescriptor conn, RecordDescriptor recordDesc, IConnectorPolicy cPolicy) throws HyracksDataException {
        IPartitionCollector collector = conn.createPartitionCollector((IHyracksTaskContext)task, recordDesc, partition, td.getInputPartitionCounts()[i], td.getPartitionCount());
        if (cPolicy.materializeOnReceiveSide()) {
            return new ReceiveSideMaterializingCollector(task, this.ncs.getPartitionManager(), collector, task.getTaskAttemptId(), this.ncs.getExecutor());
        }
        return collector;
    }

    private IPartitionWriterFactory createPartitionWriterFactory(final IHyracksTaskContext ctx, IConnectorPolicy cPolicy, final JobId jobId, final IConnectorDescriptor conn, final int senderIndex, final TaskAttemptId taId, EnumSet<JobFlag> flags) {
        Object factory = cPolicy.materializeOnSendSide() ? (cPolicy.consumerWaitsForProducerToFinish() ? new IPartitionWriterFactory(){

            public IFrameWriter createFrameWriter(int receiverIndex) throws HyracksDataException {
                return new MaterializedPartitionWriter(ctx, StartTasksWork.this.ncs.getPartitionManager(), new PartitionId(jobId, conn.getConnectorId(), senderIndex, receiverIndex), taId, StartTasksWork.this.ncs.getExecutor());
            }
        } : new IPartitionWriterFactory(){

            public IFrameWriter createFrameWriter(int receiverIndex) throws HyracksDataException {
                return new MaterializingPipelinedPartition(ctx, StartTasksWork.this.ncs.getPartitionManager(), new PartitionId(jobId, conn.getConnectorId(), senderIndex, receiverIndex), taId, StartTasksWork.this.ncs.getExecutor());
            }
        }) : new IPartitionWriterFactory(){

            public IFrameWriter createFrameWriter(int receiverIndex) throws HyracksDataException {
                return new PipelinedPartition(ctx, StartTasksWork.this.ncs.getPartitionManager(), new PartitionId(jobId, conn.getConnectorId(), senderIndex, receiverIndex), taId);
            }
        };
        if (flags.contains(JobFlag.PROFILE_RUNTIME)) {
            factory = new ProfilingPartitionWriterFactory(ctx, conn, senderIndex, (IPartitionWriterFactory)factory);
        }
        return factory;
    }
}

