/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.work;

import edu.uci.ics.hyracks.api.channels.IInputChannel;
import edu.uci.ics.hyracks.api.comm.NetworkAddress;
import edu.uci.ics.hyracks.api.comm.PartitionChannel;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.comm.channels.IChannelConnectionFactory;
import edu.uci.ics.hyracks.comm.channels.NetworkInputChannel;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import edu.uci.ics.hyracks.control.nc.Joblet;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;

public class ReportPartitionAvailabilityWork
extends AbstractWork {
    private final NodeControllerService ncs;
    private final PartitionId pid;
    private final NetworkAddress networkAddress;

    public ReportPartitionAvailabilityWork(NodeControllerService ncs, PartitionId pid, NetworkAddress networkAddress) {
        this.ncs = ncs;
        this.pid = pid;
        this.networkAddress = networkAddress;
    }

    public void run() {
        try {
            Map<JobId, Joblet> jobletMap = this.ncs.getJobletMap();
            Joblet ji = jobletMap.get(this.pid.getJobId());
            if (ji != null) {
                PartitionChannel channel = new PartitionChannel(this.pid, (IInputChannel)new NetworkInputChannel((IChannelConnectionFactory)this.ncs.getNetworkManager(), (SocketAddress)new InetSocketAddress(InetAddress.getByAddress(this.networkAddress.getIpAddress()), this.networkAddress.getPort()), this.pid, 5));
                ji.reportPartitionAvailability(channel);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

