/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.work;

import edu.uci.ics.hyracks.api.dataset.IDatasetPartitionManager;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import edu.uci.ics.hyracks.control.nc.Task;
import java.util.List;

public class NotifyTaskFailureWork
extends AbstractWork {
    private final NodeControllerService ncs;
    private final Task task;
    private final List<Exception> exceptions;

    public NotifyTaskFailureWork(NodeControllerService ncs, Task task, List<Exception> exceptions) {
        this.ncs = ncs;
        this.task = task;
        this.exceptions = exceptions;
    }

    public void run() {
        try {
            JobId jobId = this.task.getJobletContext().getJobId();
            IDatasetPartitionManager dpm = this.ncs.getDatasetPartitionManager();
            if (dpm != null) {
                dpm.abortReader(jobId);
            }
            this.ncs.getClusterController().notifyTaskFailure(jobId, this.task.getTaskAttemptId(), this.ncs.getId(), this.exceptions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.task.getJoblet().removeTask(this.task);
    }
}

