/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.work;

import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.job.IJobSerializerDeserializerContainer;
import edu.uci.ics.hyracks.control.common.base.IClusterController;
import edu.uci.ics.hyracks.control.common.context.ServerContext;
import edu.uci.ics.hyracks.control.common.deployment.DeploymentStatus;
import edu.uci.ics.hyracks.control.common.deployment.DeploymentUtils;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import java.net.URL;
import java.util.List;

public class DeployBinaryWork
extends AbstractWork {
    private DeploymentId deploymentId;
    private NodeControllerService ncs;
    private List<URL> binaryURLs;

    public DeployBinaryWork(NodeControllerService ncs, DeploymentId deploymentId, List<URL> binaryURLs) {
        this.deploymentId = deploymentId;
        this.ncs = ncs;
        this.binaryURLs = binaryURLs;
    }

    public void run() {
        DeploymentStatus status;
        try {
            DeploymentUtils.deploy((DeploymentId)this.deploymentId, this.binaryURLs, (IJobSerializerDeserializerContainer)this.ncs.getApplicationContext().getJobSerializerDeserializerContainer(), (ServerContext)this.ncs.getServerContext(), (boolean)true);
            status = DeploymentStatus.SUCCEED;
        }
        catch (Exception e) {
            status = DeploymentStatus.FAIL;
            e.printStackTrace();
        }
        try {
            IClusterController ccs = this.ncs.getClusterController();
            ccs.notifyDeployBinary(this.deploymentId, this.ncs.getId(), status);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

