/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.work;

import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.job.JobStatus;
import edu.uci.ics.hyracks.api.partitions.IPartition;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import edu.uci.ics.hyracks.control.nc.Joblet;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CleanupJobletWork
extends AbstractWork {
    private static final Logger LOGGER = Logger.getLogger(CleanupJobletWork.class.getName());
    private final NodeControllerService ncs;
    private final JobId jobId;
    private JobStatus status;

    public CleanupJobletWork(NodeControllerService ncs, JobId jobId, JobStatus status) {
        this.ncs = ncs;
        this.jobId = jobId;
        this.status = status;
    }

    public void run() {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Cleaning up after job: " + this.jobId);
        }
        final ArrayList<IPartition> unregisteredPartitions = new ArrayList<IPartition>();
        this.ncs.getPartitionManager().unregisterPartitions(this.jobId, unregisteredPartitions);
        this.ncs.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                for (IPartition p : unregisteredPartitions) {
                    p.deallocate();
                }
            }
        });
        Map<JobId, Joblet> jobletMap = this.ncs.getJobletMap();
        Joblet joblet = jobletMap.remove(this.jobId);
        if (joblet != null) {
            joblet.cleanup(this.status);
        }
    }
}

