/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.work;

import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.common.job.profiling.om.JobProfile;
import edu.uci.ics.hyracks.control.common.job.profiling.om.JobletProfile;
import edu.uci.ics.hyracks.control.common.work.FutureValue;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import edu.uci.ics.hyracks.control.nc.Joblet;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BuildJobProfilesWork
extends SynchronizableWork {
    private final NodeControllerService ncs;
    private final FutureValue<List<JobProfile>> fv;

    public BuildJobProfilesWork(NodeControllerService ncs, FutureValue<List<JobProfile>> fv) {
        this.ncs = ncs;
        this.fv = fv;
    }

    protected void doRun() throws Exception {
        ArrayList<JobProfile> profiles = new ArrayList<JobProfile>();
        Map<JobId, Joblet> jobletMap = this.ncs.getJobletMap();
        for (Joblet ji : jobletMap.values()) {
            profiles.add(new JobProfile(ji.getJobId()));
        }
        for (JobProfile jProfile : profiles) {
            JobletProfile jobletProfile = new JobletProfile(this.ncs.getId());
            Joblet ji = jobletMap.get(jProfile.getJobId());
            if (ji == null) continue;
            ji.dumpProfile(jobletProfile);
            jProfile.getJobletProfiles().put(this.ncs.getId(), jobletProfile);
        }
        this.fv.setValue(profiles);
    }
}

