/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.work;

import edu.uci.ics.hyracks.api.application.IApplicationContext;
import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.messages.IMessage;
import edu.uci.ics.hyracks.control.common.deployment.DeploymentUtils;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import edu.uci.ics.hyracks.control.nc.application.NCApplicationContext;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationMessageWork
extends AbstractWork {
    private static final Logger LOGGER = Logger.getLogger(ApplicationMessageWork.class.getName());
    private byte[] message;
    private DeploymentId deploymentId;
    private String nodeId;
    private NodeControllerService ncs;

    public ApplicationMessageWork(NodeControllerService ncs, byte[] message, DeploymentId deploymentId, String nodeId) {
        this.ncs = ncs;
        this.deploymentId = deploymentId;
        this.nodeId = nodeId;
        this.message = message;
    }

    public void run() {
        NCApplicationContext ctx = this.ncs.getApplicationContext();
        try {
            IMessage data = (IMessage)DeploymentUtils.deserialize((byte[])this.message, (DeploymentId)this.deploymentId, (IApplicationContext)ctx);
            if (ctx.getMessageBroker() != null) {
                ctx.getMessageBroker().receivedMessage(data, this.nodeId);
            } else {
                LOGGER.log(Level.WARNING, "Messsage was sent, but no Message Broker set!");
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Error in application message delivery!", e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "nodeID: " + this.nodeId;
    }
}

