/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.work;

import edu.uci.ics.hyracks.api.dataflow.TaskAttemptId;
import edu.uci.ics.hyracks.api.dataset.IDatasetPartitionManager;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import edu.uci.ics.hyracks.control.nc.Joblet;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import edu.uci.ics.hyracks.control.nc.Task;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbortTasksWork
extends AbstractWork {
    private static final Logger LOGGER = Logger.getLogger(AbortTasksWork.class.getName());
    private final NodeControllerService ncs;
    private final JobId jobId;
    private final List<TaskAttemptId> tasks;

    public AbortTasksWork(NodeControllerService ncs, JobId jobId, List<TaskAttemptId> tasks) {
        this.ncs = ncs;
        this.jobId = jobId;
        this.tasks = tasks;
    }

    public void run() {
        Map<JobId, Joblet> jobletMap;
        Joblet ji;
        IDatasetPartitionManager dpm;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Aborting Tasks: " + this.jobId + ":" + this.tasks);
        }
        if ((dpm = this.ncs.getDatasetPartitionManager()) != null) {
            this.ncs.getDatasetPartitionManager().abortReader(this.jobId);
        }
        if ((ji = (jobletMap = this.ncs.getJobletMap()).get(this.jobId)) != null) {
            Map<TaskAttemptId, Task> taskMap = ji.getTaskMap();
            for (TaskAttemptId taId : this.tasks) {
                Task task = taskMap.get(taId);
                if (task == null) continue;
                task.abort();
            }
        }
    }
}

