/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.profiling;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ConnectorDescriptorId;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.profiling.counters.ICounter;
import java.nio.ByteBuffer;

public class ConnectorSenderProfilingFrameWriter
implements IFrameWriter {
    private final IFrameWriter writer;
    private final ICounter openCounter;
    private final ICounter closeCounter;
    private final ICounter frameCounter;

    public ConnectorSenderProfilingFrameWriter(IHyracksTaskContext ctx, IFrameWriter writer, ConnectorDescriptorId cdId, int senderIndex, int receiverIndex) {
        this.writer = writer;
        int attempt = ctx.getTaskAttemptId().getAttempt();
        this.openCounter = ctx.getCounterContext().getCounter(cdId + ".sender." + attempt + "." + senderIndex + "." + receiverIndex + ".open", true);
        this.closeCounter = ctx.getCounterContext().getCounter(cdId + ".sender." + attempt + "." + senderIndex + "." + receiverIndex + ".close", true);
        this.frameCounter = ctx.getCounterContext().getCounter(cdId + ".sender." + attempt + "." + senderIndex + "." + receiverIndex + ".nextFrame", true);
    }

    public void open() throws HyracksDataException {
        this.writer.open();
        this.openCounter.update(1L);
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.frameCounter.update(1L);
        this.writer.nextFrame(buffer);
    }

    public void close() throws HyracksDataException {
        this.closeCounter.update(1L);
        this.writer.close();
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }
}

