/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.profiling;

import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ConnectorDescriptorId;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.profiling.counters.ICounter;
import java.nio.ByteBuffer;

public class ConnectorReceiverProfilingFrameReader
implements IFrameReader {
    private final IFrameReader reader;
    private final ICounter openCounter;
    private final ICounter closeCounter;
    private final ICounter frameCounter;

    public ConnectorReceiverProfilingFrameReader(IHyracksTaskContext ctx, IFrameReader reader, ConnectorDescriptorId cdId, int receiverIndex) {
        this.reader = reader;
        this.openCounter = ctx.getCounterContext().getCounter(cdId + ".receiver." + receiverIndex + ".open", true);
        this.closeCounter = ctx.getCounterContext().getCounter(cdId + ".receiver." + receiverIndex + ".close", true);
        this.frameCounter = ctx.getCounterContext().getCounter(cdId + ".receiver." + receiverIndex + ".nextFrame", true);
    }

    public void open() throws HyracksDataException {
        this.reader.open();
        this.openCounter.update(1L);
    }

    public boolean nextFrame(ByteBuffer buffer) throws HyracksDataException {
        boolean status = this.reader.nextFrame(buffer);
        if (status) {
            this.frameCounter.update(1L);
        }
        return status;
    }

    public void close() throws HyracksDataException {
        this.reader.close();
        this.closeCounter.update(1L);
    }
}

