/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.partitions;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.TaskAttemptId;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.partitions.IPartition;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.control.common.job.PartitionState;
import edu.uci.ics.hyracks.control.nc.partitions.PartitionManager;
import java.nio.ByteBuffer;

public class PipelinedPartition
implements IFrameWriter,
IPartition {
    private final IHyracksTaskContext ctx;
    private final PartitionManager manager;
    private final PartitionId pid;
    private final TaskAttemptId taId;
    private IFrameWriter delegate;
    private boolean pendingConnection;
    private boolean failed;

    public PipelinedPartition(IHyracksTaskContext ctx, PartitionManager manager, PartitionId pid, TaskAttemptId taId) {
        this.ctx = ctx;
        this.manager = manager;
        this.pid = pid;
        this.taId = taId;
    }

    public IHyracksTaskContext getTaskContext() {
        return this.ctx;
    }

    public boolean isReusable() {
        return false;
    }

    public void deallocate() {
    }

    public synchronized void writeTo(IFrameWriter writer) {
        this.delegate = writer;
        this.notifyAll();
    }

    public void open() throws HyracksDataException {
        this.manager.registerPartition(this.pid, this.taId, this, PartitionState.STARTED);
        this.failed = false;
        this.pendingConnection = true;
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.ensureConnected();
        this.delegate.nextFrame(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureConnected() throws HyracksDataException {
        if (this.pendingConnection) {
            PipelinedPartition pipelinedPartition = this;
            synchronized (pipelinedPartition) {
                while (this.delegate == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                }
            }
            this.delegate.open();
        }
        this.pendingConnection = false;
    }

    public void fail() throws HyracksDataException {
        this.failed = true;
        if (this.delegate != null) {
            this.delegate.fail();
        }
    }

    public void close() throws HyracksDataException {
        if (!this.failed) {
            this.ensureConnected();
            this.manager.updatePartitionState(this.pid, this.taId, this, PartitionState.COMMITTED);
            this.delegate.close();
        }
    }
}

