/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.partitions;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.dataflow.TaskAttemptId;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.io.IWorkspaceFileFactory;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.partitions.IPartition;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.comm.channels.NetworkOutputChannel;
import edu.uci.ics.hyracks.control.common.job.PartitionDescriptor;
import edu.uci.ics.hyracks.control.common.job.PartitionState;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import edu.uci.ics.hyracks.control.nc.io.IOManager;
import edu.uci.ics.hyracks.control.nc.io.WorkspaceFileFactory;
import edu.uci.ics.hyracks.control.nc.resources.DefaultDeallocatableRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PartitionManager {
    private final NodeControllerService ncs;
    private final Map<PartitionId, List<IPartition>> partitionMap;
    private final DefaultDeallocatableRegistry deallocatableRegistry;
    private final IWorkspaceFileFactory fileFactory;

    public PartitionManager(NodeControllerService ncs) {
        this.ncs = ncs;
        this.partitionMap = new HashMap<PartitionId, List<IPartition>>();
        this.deallocatableRegistry = new DefaultDeallocatableRegistry();
        this.fileFactory = new WorkspaceFileFactory(this.deallocatableRegistry, (IOManager)ncs.getRootContext().getIOManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPartition(PartitionId pid, TaskAttemptId taId, IPartition partition, PartitionState state) throws HyracksDataException {
        PartitionManager partitionManager = this;
        synchronized (partitionManager) {
            List<IPartition> pList = this.partitionMap.get(pid);
            if (pList == null) {
                pList = new ArrayList<IPartition>();
                this.partitionMap.put(pid, pList);
            }
            pList.add(partition);
        }
        this.updatePartitionState(pid, taId, partition, state);
    }

    public void updatePartitionState(PartitionId pid, TaskAttemptId taId, IPartition partition, PartitionState state) throws HyracksDataException {
        PartitionDescriptor desc = new PartitionDescriptor(pid, this.ncs.getId(), taId, partition.isReusable());
        desc.setState(state);
        try {
            this.ncs.getClusterController().registerPartitionProvider(desc);
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public synchronized IPartition getPartition(PartitionId pid) {
        return this.partitionMap.get(pid).get(0);
    }

    public synchronized void unregisterPartitions(JobId jobId, Collection<IPartition> unregisteredPartitions) {
        Iterator<Map.Entry<PartitionId, List<IPartition>>> i = this.partitionMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<PartitionId, List<IPartition>> e = i.next();
            PartitionId pid = e.getKey();
            if (!jobId.equals((Object)pid.getJobId())) continue;
            for (IPartition p : e.getValue()) {
                unregisteredPartitions.add(p);
            }
            i.remove();
        }
    }

    public synchronized void registerPartitionRequest(PartitionId partitionId, NetworkOutputChannel writer) throws HyracksException {
        List<IPartition> pList = this.partitionMap.get(partitionId);
        if (pList != null && !pList.isEmpty()) {
            IPartition partition = pList.get(0);
            writer.setFrameSize(partition.getTaskContext().getFrameSize());
            partition.writeTo((IFrameWriter)writer);
            if (!partition.isReusable()) {
                this.partitionMap.remove(partitionId);
            }
        } else {
            throw new HyracksException("Request for unknown partition " + partitionId);
        }
    }

    public IWorkspaceFileFactory getFileFactory() {
        return this.fileFactory;
    }

    public void close() {
        this.deallocatableRegistry.close();
    }
}

