/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.partitions;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.TaskAttemptId;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.api.io.IFileHandle;
import edu.uci.ics.hyracks.api.io.IIOManager;
import edu.uci.ics.hyracks.api.partitions.IPartition;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.control.common.job.PartitionState;
import edu.uci.ics.hyracks.control.nc.io.IOManager;
import edu.uci.ics.hyracks.control.nc.partitions.PartitionManager;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaterializingPipelinedPartition
implements IFrameWriter,
IPartition {
    private static final Logger LOGGER = Logger.getLogger(MaterializingPipelinedPartition.class.getName());
    private final IHyracksTaskContext ctx;
    private final Executor executor;
    private final IOManager ioManager;
    private final PartitionManager manager;
    private final PartitionId pid;
    private final TaskAttemptId taId;
    private FileReference fRef;
    private IFileHandle handle;
    private long size;
    private boolean eos;
    private boolean failed;

    public MaterializingPipelinedPartition(IHyracksTaskContext ctx, PartitionManager manager, PartitionId pid, TaskAttemptId taId, Executor executor) {
        this.ctx = ctx;
        this.executor = executor;
        this.ioManager = (IOManager)ctx.getIOManager();
        this.manager = manager;
        this.pid = pid;
        this.taId = taId;
    }

    public IHyracksTaskContext getTaskContext() {
        return this.ctx;
    }

    public void deallocate() {
        this.fRef.delete();
    }

    public void writeTo(final IFrameWriter writer) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IFileHandle fh = MaterializingPipelinedPartition.this.ioManager.open(MaterializingPipelinedPartition.this.fRef, IIOManager.FileReadWriteMode.READ_ONLY, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
                    try {
                        writer.open();
                        try {
                            long offset = 0L;
                            ByteBuffer buffer = MaterializingPipelinedPartition.this.ctx.allocateFrame();
                            boolean fail = false;
                            boolean done = false;
                            while (!fail && !done) {
                                MaterializingPipelinedPartition materializingPipelinedPartition = MaterializingPipelinedPartition.this;
                                synchronized (materializingPipelinedPartition) {
                                    while (offset >= MaterializingPipelinedPartition.this.size && !MaterializingPipelinedPartition.this.eos && !MaterializingPipelinedPartition.this.failed) {
                                        try {
                                            MaterializingPipelinedPartition.this.wait();
                                        }
                                        catch (InterruptedException e) {
                                            throw new HyracksDataException((Throwable)e);
                                        }
                                    }
                                    fail = MaterializingPipelinedPartition.this.failed;
                                    done = MaterializingPipelinedPartition.this.eos && offset >= MaterializingPipelinedPartition.this.size;
                                }
                                if (fail) {
                                    writer.fail();
                                    continue;
                                }
                                if (done) continue;
                                buffer.clear();
                                long readLen = MaterializingPipelinedPartition.this.ioManager.syncRead(fh, offset, buffer);
                                if (readLen < (long)buffer.capacity()) {
                                    throw new HyracksDataException("Premature end of file");
                                }
                                offset += readLen;
                                buffer.flip();
                                writer.nextFrame(buffer);
                            }
                        }
                        finally {
                            writer.close();
                        }
                    }
                    finally {
                        MaterializingPipelinedPartition.this.ioManager.close(fh);
                    }
                }
                catch (HyracksDataException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public boolean isReusable() {
        return true;
    }

    public void open() throws HyracksDataException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("open(" + this.pid + " by " + this.taId);
        }
        this.fRef = this.manager.getFileFactory().createUnmanagedWorkspaceFile(this.pid.toString().replace(":", "$"));
        this.handle = this.ctx.getIOManager().open(this.fRef, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
        this.size = 0L;
        this.eos = false;
        this.failed = false;
        this.manager.registerPartition(this.pid, this.taId, this, PartitionState.STARTED);
    }

    public synchronized void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.size += (long)this.ctx.getIOManager().syncWrite(this.handle, this.size, buffer);
        this.notifyAll();
    }

    public synchronized void fail() throws HyracksDataException {
        this.failed = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws HyracksDataException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("close(" + this.pid + " by " + this.taId);
        }
        boolean commit = false;
        MaterializingPipelinedPartition materializingPipelinedPartition = this;
        synchronized (materializingPipelinedPartition) {
            this.eos = true;
            this.ctx.getIOManager().close(this.handle);
            this.handle = null;
            commit = !this.failed;
            this.notifyAll();
        }
        if (commit) {
            this.manager.updatePartitionState(this.pid, this.taId, this, PartitionState.COMMITTED);
        }
    }
}

