/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.partitions;

import edu.uci.ics.hyracks.api.channels.IInputChannel;
import edu.uci.ics.hyracks.api.channels.IInputChannelMonitor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksCommonContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.partitions.IPartition;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.control.nc.partitions.PartitionManager;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;

public class MaterializedPartitionInputChannel
implements IInputChannel {
    private final int nBuffers;
    private final Queue<ByteBuffer> emptyQueue;
    private final Queue<ByteBuffer> fullQueue;
    private final PartitionId pid;
    private final PartitionManager manager;
    private final FrameWriter writer;
    private IInputChannelMonitor monitor;
    private Object attachment;

    public MaterializedPartitionInputChannel(int nBuffers, PartitionId pid, PartitionManager manager) {
        this.nBuffers = nBuffers;
        this.emptyQueue = new ArrayDeque<ByteBuffer>(nBuffers);
        this.fullQueue = new ArrayDeque<ByteBuffer>(nBuffers);
        this.pid = pid;
        this.manager = manager;
        this.writer = new FrameWriter();
    }

    public void registerMonitor(IInputChannelMonitor monitor) {
        this.monitor = monitor;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public ByteBuffer getNextBuffer() {
        return this.fullQueue.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycleBuffer(ByteBuffer buffer) {
        buffer.clear();
        MaterializedPartitionInputChannel materializedPartitionInputChannel = this;
        synchronized (materializedPartitionInputChannel) {
            this.emptyQueue.add(buffer);
            this.notifyAll();
        }
    }

    public void open(IHyracksCommonContext ctx) throws HyracksDataException {
        for (int i = 0; i < this.nBuffers; ++i) {
            this.emptyQueue.add(ctx.allocateFrame());
        }
        IPartition partition = this.manager.getPartition(this.pid);
        partition.writeTo((IFrameWriter)this.writer);
    }

    public void close() throws HyracksDataException {
    }

    private class FrameWriter
    implements IFrameWriter {
        private FrameWriter() {
        }

        public void open() throws HyracksDataException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            MaterializedPartitionInputChannel materializedPartitionInputChannel = MaterializedPartitionInputChannel.this;
            synchronized (materializedPartitionInputChannel) {
                while (MaterializedPartitionInputChannel.this.emptyQueue.isEmpty()) {
                    try {
                        MaterializedPartitionInputChannel.this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                }
                ByteBuffer destFrame = (ByteBuffer)MaterializedPartitionInputChannel.this.emptyQueue.poll();
                buffer.position(0);
                buffer.limit(buffer.capacity());
                destFrame.clear();
                destFrame.put(buffer);
                MaterializedPartitionInputChannel.this.fullQueue.add(destFrame);
                MaterializedPartitionInputChannel.this.monitor.notifyDataAvailability((IInputChannel)MaterializedPartitionInputChannel.this, 1);
            }
        }

        public void fail() throws HyracksDataException {
        }

        public void close() throws HyracksDataException {
            MaterializedPartitionInputChannel.this.monitor.notifyEndOfStream((IInputChannel)MaterializedPartitionInputChannel.this);
        }
    }
}

