/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.net;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.comm.NetworkAddress;
import edu.uci.ics.hyracks.api.dataset.IDatasetPartitionManager;
import edu.uci.ics.hyracks.api.dataset.ResultSetId;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.comm.channels.IChannelConnectionFactory;
import edu.uci.ics.hyracks.comm.channels.NetworkOutputChannel;
import edu.uci.ics.hyracks.net.buffers.ICloseableBufferAcceptor;
import edu.uci.ics.hyracks.net.exceptions.NetException;
import edu.uci.ics.hyracks.net.protocols.muxdemux.ChannelControlBlock;
import edu.uci.ics.hyracks.net.protocols.muxdemux.IChannelOpenListener;
import edu.uci.ics.hyracks.net.protocols.muxdemux.MultiplexedConnection;
import edu.uci.ics.hyracks.net.protocols.muxdemux.MuxDemux;
import edu.uci.ics.hyracks.net.protocols.muxdemux.MuxDemuxPerformanceCounters;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatasetNetworkManager
implements IChannelConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger(DatasetNetworkManager.class.getName());
    private static final int MAX_CONNECTION_ATTEMPTS = 5;
    static final int INITIAL_MESSAGE_SIZE = 20;
    private final IDatasetPartitionManager partitionManager;
    private final MuxDemux md;
    private NetworkAddress networkAddress;

    public DatasetNetworkManager(InetAddress inetAddress, IDatasetPartitionManager partitionManager, int nThreads) throws IOException {
        this.partitionManager = partitionManager;
        this.md = new MuxDemux(new InetSocketAddress(inetAddress, 0), (IChannelOpenListener)new ChannelOpenListener(), nThreads, 5);
    }

    public void start() throws IOException {
        this.md.start();
        InetSocketAddress sockAddr = this.md.getLocalAddress();
        this.networkAddress = new NetworkAddress(sockAddr.getAddress().getAddress(), sockAddr.getPort());
    }

    public NetworkAddress getNetworkAddress() {
        return this.networkAddress;
    }

    public void stop() {
    }

    public ChannelControlBlock connect(SocketAddress remoteAddress) throws InterruptedException, NetException {
        MultiplexedConnection mConn = this.md.connect((InetSocketAddress)remoteAddress);
        return mConn.openChannel();
    }

    public MuxDemuxPerformanceCounters getPerformanceCounters() {
        return this.md.getPerformanceCounters();
    }

    private class InitialBufferAcceptor
    implements ICloseableBufferAcceptor {
        private final ChannelControlBlock ccb;
        private NetworkOutputChannel noc;

        public InitialBufferAcceptor(ChannelControlBlock ccb) {
            this.ccb = ccb;
        }

        public void accept(ByteBuffer buffer) {
            JobId jobId = new JobId(buffer.getLong());
            ResultSetId rsId = new ResultSetId(buffer.getLong());
            int partition = buffer.getInt();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Received initial dataset partition read request for JobId: " + jobId + " partition: " + partition + " on channel: " + this.ccb);
            }
            this.noc = new NetworkOutputChannel(this.ccb, 1);
            try {
                DatasetNetworkManager.this.partitionManager.initializeDatasetPartitionReader(jobId, rsId, partition, (IFrameWriter)this.noc);
            }
            catch (HyracksException e) {
                this.noc.abort();
            }
        }

        public void close() {
        }

        public void error(int ecode) {
            if (this.noc != null) {
                this.noc.abort();
            }
        }
    }

    private class ChannelOpenListener
    implements IChannelOpenListener {
        private ChannelOpenListener() {
        }

        public void channelOpened(ChannelControlBlock channel) {
            channel.getReadInterface().setFullBufferAcceptor((ICloseableBufferAcceptor)new InitialBufferAcceptor(channel));
            channel.getReadInterface().getEmptyBufferAcceptor().accept(ByteBuffer.allocate(20));
        }
    }
}

