/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.io.profiling;

import edu.uci.ics.hyracks.control.nc.io.profiling.IIOCounter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class IOCounterLinux
implements IIOCounter {
    public static final String COMMAND = "iostat";
    public static final String COMMAND2 = "cat /proc/self/io";
    public static final int PAGE_SIZE = 4096;
    private final long baseReads = this.getReads();
    private final long baseWrites = this.getWrites();

    @Override
    public long getReads() {
        try {
            long reads = this.extractColumn(4);
            return reads - this.baseReads;
        }
        catch (IOException e) {
            try {
                long reads = this.extractRow(4);
                return reads / 4096L;
            }
            catch (IOException e2) {
                return 0L;
            }
        }
    }

    @Override
    public long getWrites() {
        try {
            long writes = this.extractColumn(5);
            return writes - this.baseWrites;
        }
        catch (IOException e) {
            try {
                long writes = this.extractRow(5);
                long cancelledWrites = this.extractRow(6);
                return (writes - cancelledWrites) / 4096L;
            }
            catch (IOException e2) {
                return 0L;
            }
        }
    }

    private long extractColumn(int columnIndex) throws IOException {
        BufferedReader reader = this.exec(COMMAND);
        String line = null;
        boolean device = false;
        long ios = 0L;
        block0: while ((line = reader.readLine()) != null) {
            if (line.contains("Blk_read")) {
                device = true;
                continue;
            }
            if (!device) continue;
            StringTokenizer tokenizer = new StringTokenizer(line);
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String column = tokenizer.nextToken();
                if (i == columnIndex) {
                    ios += Long.parseLong(column);
                    continue block0;
                }
                ++i;
            }
        }
        reader.close();
        return ios;
    }

    private long extractRow(int rowIndex) throws IOException {
        BufferedReader reader = this.exec(COMMAND2);
        String line = null;
        long ios = 0L;
        int i = 0;
        while ((line = reader.readLine()) != null) {
            if (i == rowIndex) {
                StringTokenizer tokenizer = new StringTokenizer(line);
                int j = 0;
                while (tokenizer.hasMoreTokens()) {
                    String column = tokenizer.nextToken();
                    if (j == 1) {
                        ios = Long.parseLong(column);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        reader.close();
        return ios;
    }

    private BufferedReader exec(String command) throws IOException {
        Process p = Runtime.getRuntime().exec(command);
        return new BufferedReader(new InputStreamReader(p.getInputStream()));
    }
}

