/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.io;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.api.io.IWorkspaceFileFactory;
import edu.uci.ics.hyracks.api.resources.IDeallocatable;
import edu.uci.ics.hyracks.api.resources.IDeallocatableRegistry;
import edu.uci.ics.hyracks.control.nc.io.IOManager;

public final class WorkspaceFileFactory
implements IWorkspaceFileFactory {
    private final IDeallocatableRegistry registry;
    private final IOManager ioManager;

    public WorkspaceFileFactory(IDeallocatableRegistry registry, IOManager ioManager) {
        this.registry = registry;
        this.ioManager = ioManager;
    }

    public FileReference createManagedWorkspaceFile(String prefix) throws HyracksDataException {
        final FileReference fRef = this.ioManager.createWorkspaceFile(prefix);
        this.registry.registerDeallocatable(new IDeallocatable(){

            public void deallocate() {
                fRef.delete();
            }
        });
        return fRef;
    }

    public FileReference createUnmanagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.ioManager.createWorkspaceFile(prefix);
    }
}

