/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.io;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.api.io.IFileHandle;
import edu.uci.ics.hyracks.api.io.IIOFuture;
import edu.uci.ics.hyracks.api.io.IIOManager;
import edu.uci.ics.hyracks.api.io.IODeviceHandle;
import edu.uci.ics.hyracks.control.nc.io.FileHandle;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

public class IOManager
implements IIOManager {
    private final List<IODeviceHandle> ioDevices;
    private Executor executor;
    private final List<IODeviceHandle> workAreaIODevices;
    private int workAreaDeviceIndex;

    public IOManager(List<IODeviceHandle> devices, Executor executor) throws HyracksException {
        this(devices);
        this.executor = executor;
    }

    public IOManager(List<IODeviceHandle> devices) throws HyracksException {
        this.ioDevices = Collections.unmodifiableList(devices);
        this.workAreaIODevices = new ArrayList<IODeviceHandle>();
        for (IODeviceHandle d : this.ioDevices) {
            if (d.getWorkAreaPath() == null) continue;
            new File(d.getPath(), d.getWorkAreaPath()).mkdirs();
            this.workAreaIODevices.add(d);
        }
        if (this.workAreaIODevices.isEmpty()) {
            throw new HyracksException("No devices with work areas found");
        }
        this.workAreaDeviceIndex = 0;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public List<IODeviceHandle> getIODevices() {
        return this.ioDevices;
    }

    public IFileHandle open(FileReference fileRef, IIOManager.FileReadWriteMode rwMode, IIOManager.FileSyncMode syncMode) throws HyracksDataException {
        FileHandle fHandle = new FileHandle(fileRef);
        try {
            fHandle.open(rwMode, syncMode);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        return fHandle;
    }

    public int syncWrite(IFileHandle fHandle, long offset, ByteBuffer data) throws HyracksDataException {
        try {
            int n = 0;
            int remaining = data.remaining();
            while (remaining > 0) {
                int len = ((FileHandle)fHandle).getFileChannel().write(data, offset);
                if (len < 0) {
                    throw new HyracksDataException("Error writing to file: " + ((FileHandle)fHandle).getFileReference().toString());
                }
                remaining -= len;
                offset += (long)len;
                n += len;
            }
            return n;
        }
        catch (HyracksDataException e) {
            throw e;
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public int syncRead(IFileHandle fHandle, long offset, ByteBuffer data) throws HyracksDataException {
        try {
            int n = 0;
            int remaining = data.remaining();
            while (remaining > 0) {
                int len = ((FileHandle)fHandle).getFileChannel().read(data, offset);
                if (len < 0) {
                    return -1;
                }
                remaining -= len;
                offset += (long)len;
                n += len;
            }
            return n;
        }
        catch (HyracksDataException e) {
            throw e;
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public IIOFuture asyncWrite(IFileHandle fHandle, long offset, ByteBuffer data) {
        AsyncWriteRequest req = new AsyncWriteRequest((FileHandle)fHandle, offset, data);
        this.executor.execute(req);
        return req;
    }

    public IIOFuture asyncRead(IFileHandle fHandle, long offset, ByteBuffer data) {
        AsyncReadRequest req = new AsyncReadRequest((FileHandle)fHandle, offset, data);
        this.executor.execute(req);
        return req;
    }

    public void close(IFileHandle fHandle) throws HyracksDataException {
        try {
            ((FileHandle)fHandle).close();
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public synchronized FileReference createWorkspaceFile(String prefix) throws HyracksDataException {
        File waf;
        IODeviceHandle dev = this.workAreaIODevices.get(this.workAreaDeviceIndex);
        this.workAreaDeviceIndex = (this.workAreaDeviceIndex + 1) % this.workAreaIODevices.size();
        String waPath = dev.getWorkAreaPath();
        try {
            waf = File.createTempFile(prefix, ".waf", new File(dev.getPath(), waPath));
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        return dev.createFileReference(waPath + File.separator + waf.getName());
    }

    public void sync(IFileHandle fileHandle, boolean metadata) throws HyracksDataException {
        try {
            ((FileHandle)fileHandle).sync(metadata);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    private class AsyncWriteRequest
    extends AsyncRequest {
        private AsyncWriteRequest(FileHandle fHandle, long offset, ByteBuffer data) {
            super(fHandle, offset, data);
        }

        @Override
        protected int performOperation() throws HyracksDataException {
            return IOManager.this.syncWrite(this.fHandle, this.offset, this.data);
        }
    }

    private class AsyncReadRequest
    extends AsyncRequest {
        private AsyncReadRequest(FileHandle fHandle, long offset, ByteBuffer data) {
            super(fHandle, offset, data);
        }

        @Override
        protected int performOperation() throws HyracksDataException {
            return IOManager.this.syncRead(this.fHandle, this.offset, this.data);
        }
    }

    private abstract class AsyncRequest
    implements IIOFuture,
    Runnable {
        protected final FileHandle fHandle;
        protected final long offset;
        protected final ByteBuffer data;
        private boolean complete;
        private HyracksDataException exception;
        private int result;

        private AsyncRequest(FileHandle fHandle, long offset, ByteBuffer data) {
            this.fHandle = fHandle;
            this.offset = offset;
            this.data = data;
            this.complete = false;
            this.exception = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HyracksDataException hde = null;
            int res = -1;
            try {
                res = this.performOperation();
            }
            catch (HyracksDataException e) {
                hde = e;
            }
            AsyncRequest asyncRequest = this;
            synchronized (asyncRequest) {
                this.exception = hde;
                this.result = res;
                this.complete = true;
                this.notifyAll();
            }
        }

        protected abstract int performOperation() throws HyracksDataException;

        public synchronized int synchronize() throws HyracksDataException, InterruptedException {
            while (!this.complete) {
                this.wait();
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        public synchronized boolean isComplete() {
            return this.complete;
        }
    }
}

