/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.io;

import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.api.io.IFileHandle;
import edu.uci.ics.hyracks.api.io.IIOManager;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class FileHandle
implements IFileHandle {
    private final FileReference fileRef;
    private RandomAccessFile raf;
    private FileChannel channel;

    public FileHandle(FileReference fileRef) {
        this.fileRef = fileRef;
    }

    public void open(IIOManager.FileReadWriteMode rwMode, IIOManager.FileSyncMode syncMode) throws IOException {
        String mode;
        block0 : switch (rwMode) {
            case READ_ONLY: {
                mode = "r";
                break;
            }
            case READ_WRITE: {
                this.fileRef.getFile().getAbsoluteFile().getParentFile().mkdirs();
                switch (syncMode) {
                    case METADATA_ASYNC_DATA_ASYNC: {
                        mode = "rw";
                        break block0;
                    }
                    case METADATA_ASYNC_DATA_SYNC: {
                        mode = "rwd";
                        break block0;
                    }
                    case METADATA_SYNC_DATA_SYNC: {
                        mode = "rws";
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.raf = new RandomAccessFile(this.fileRef.getFile(), mode);
        this.channel = this.raf.getChannel();
    }

    public void close() throws IOException {
        this.channel.close();
        this.raf.close();
    }

    public FileReference getFileReference() {
        return this.fileRef;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    public FileChannel getFileChannel() {
        return this.channel;
    }

    public void sync(boolean metadata) throws IOException {
        this.channel.force(metadata);
    }
}

