/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.dataset;

import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.api.io.IFileHandle;
import edu.uci.ics.hyracks.api.io.IIOManager;
import edu.uci.ics.hyracks.api.io.IWorkspaceFileFactory;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.partitions.ResultSetPartitionId;
import edu.uci.ics.hyracks.control.nc.dataset.DatasetMemoryManager;
import edu.uci.ics.hyracks.control.nc.dataset.Page;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResultState
implements IStateObject {
    private static final String FILE_PREFIX = "result_";
    private final ResultSetPartitionId resultSetPartitionId;
    private final boolean asyncMode;
    private final int frameSize;
    private final IIOManager ioManager;
    private final IWorkspaceFileFactory fileFactory;
    private final AtomicBoolean eos;
    private final AtomicBoolean failed;
    private final List<Page> localPageList;
    private FileReference fileRef;
    private IFileHandle writeFileHandle;
    private IFileHandle readFileHandle;
    private long size;
    private long persistentSize;

    ResultState(ResultSetPartitionId resultSetPartitionId, boolean asyncMode, IIOManager ioManager, IWorkspaceFileFactory fileFactory, int frameSize) {
        this.resultSetPartitionId = resultSetPartitionId;
        this.asyncMode = asyncMode;
        this.ioManager = ioManager;
        this.fileFactory = fileFactory;
        this.frameSize = frameSize;
        this.eos = new AtomicBoolean(false);
        this.failed = new AtomicBoolean(false);
        this.localPageList = new ArrayList<Page>();
        this.fileRef = null;
        this.writeFileHandle = null;
    }

    public synchronized void open() {
        this.size = 0L;
        this.persistentSize = 0L;
    }

    public synchronized void close() {
        this.eos.set(true);
        this.notifyAll();
    }

    public synchronized void closeAndDelete() {
        this.failed.set(true);
        if (this.writeFileHandle != null) {
            try {
                this.ioManager.close(this.writeFileHandle);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.fileRef != null) {
            this.fileRef.delete();
        }
    }

    public synchronized void write(ByteBuffer buffer) throws HyracksDataException {
        if (this.fileRef == null) {
            String fName = FILE_PREFIX + String.valueOf(this.resultSetPartitionId.getPartition());
            this.fileRef = this.fileFactory.createUnmanagedWorkspaceFile(fName);
            this.writeFileHandle = this.ioManager.open(this.fileRef, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
        }
        this.size += (long)this.ioManager.syncWrite(this.writeFileHandle, this.size, buffer);
        this.notifyAll();
    }

    public synchronized void write(DatasetMemoryManager datasetMemoryManager, ByteBuffer buffer) throws HyracksDataException {
        int srcOffset = 0;
        Page destPage = null;
        if (!this.localPageList.isEmpty()) {
            destPage = this.localPageList.get(this.localPageList.size() - 1);
        }
        while (srcOffset < buffer.limit()) {
            if (destPage == null || destPage.getBuffer().remaining() <= 0) {
                destPage = datasetMemoryManager.requestPage(this.resultSetPartitionId, this);
                this.localPageList.add(destPage);
            }
            int srcLength = Math.min(buffer.limit() - srcOffset, destPage.getBuffer().remaining());
            destPage.getBuffer().put(buffer.array(), srcOffset, srcLength);
            srcOffset += srcLength;
            this.size += (long)srcLength;
        }
        this.notifyAll();
    }

    public synchronized void readOpen() {
    }

    public synchronized void readClose() throws HyracksDataException {
        if (this.readFileHandle != null) {
            this.ioManager.close(this.readFileHandle);
        }
    }

    public synchronized long read(long offset, ByteBuffer buffer) throws HyracksDataException {
        long readSize = 0L;
        while (offset >= this.size && !this.eos.get() && !this.failed.get()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        if (offset >= this.size && this.eos.get() || this.failed.get()) {
            return readSize;
        }
        if (this.readFileHandle == null) {
            this.initReadFileHandle();
        }
        readSize = this.ioManager.syncRead(this.readFileHandle, offset, buffer);
        return readSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(DatasetMemoryManager datasetMemoryManager, long offset, ByteBuffer buffer) throws HyracksDataException {
        long readSize = 0L;
        ResultState resultState = this;
        synchronized (resultState) {
            while (offset >= this.size && !this.eos.get() && !this.failed.get()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            if (offset >= this.size && this.eos.get() || this.failed.get()) {
                return readSize;
            }
            if (offset < this.persistentSize) {
                if (this.readFileHandle == null) {
                    this.initReadFileHandle();
                }
                readSize = this.ioManager.syncRead(this.readFileHandle, offset, buffer);
            }
            if (readSize < (long)buffer.capacity()) {
                long localPageOffset = offset - this.persistentSize;
                int localPageIndex = (int)(localPageOffset / (long)DatasetMemoryManager.getPageSize());
                int pageOffset = (int)(localPageOffset % (long)DatasetMemoryManager.getPageSize());
                Page page = this.getPage(localPageIndex);
                if (page == null) {
                    return readSize;
                }
                readSize += (long)buffer.remaining();
                buffer.put(page.getBuffer().array(), pageOffset, buffer.remaining());
            }
        }
        datasetMemoryManager.pageReferenced(this.resultSetPartitionId);
        return readSize;
    }

    public synchronized void abort() {
        this.failed.set(true);
        this.notifyAll();
    }

    public synchronized Page returnPage() throws HyracksDataException {
        Page page = this.removePage();
        if (page == null) {
            this.ioManager.close(this.writeFileHandle);
            return null;
        }
        page.getBuffer().flip();
        if (this.fileRef == null) {
            String fName = FILE_PREFIX + String.valueOf(this.resultSetPartitionId.getPartition());
            this.fileRef = this.fileFactory.createUnmanagedWorkspaceFile(fName);
            this.writeFileHandle = this.ioManager.open(this.fileRef, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
            this.notifyAll();
        }
        long delta = this.ioManager.syncWrite(this.writeFileHandle, this.persistentSize, page.getBuffer());
        this.persistentSize += delta;
        return page;
    }

    public synchronized void setEOS(boolean eos) {
        this.eos.set(eos);
    }

    public ResultSetPartitionId getResultSetPartitionId() {
        return this.resultSetPartitionId;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public IIOManager getIOManager() {
        return this.ioManager;
    }

    public boolean getAsyncMode() {
        return this.asyncMode;
    }

    public JobId getJobId() {
        return this.resultSetPartitionId.getJobId();
    }

    public Object getId() {
        return this.resultSetPartitionId;
    }

    public long getMemoryOccupancy() {
        throw new UnsupportedOperationException();
    }

    public void toBytes(DataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void fromBytes(DataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    private Page getPage(int index) {
        Page page = null;
        if (!this.localPageList.isEmpty()) {
            page = this.localPageList.get(index);
        }
        return page;
    }

    private Page removePage() {
        Page page = null;
        if (!this.localPageList.isEmpty()) {
            page = this.localPageList.remove(this.localPageList.size() - 1);
        }
        return page;
    }

    private void initReadFileHandle() throws HyracksDataException {
        while (this.fileRef == null && !this.failed.get()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        if (this.failed.get()) {
            return;
        }
        this.readFileHandle = this.ioManager.open(this.fileRef, IIOManager.FileReadWriteMode.READ_ONLY, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
    }
}

