/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.dataset;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataset.IDatasetPartitionManager;
import edu.uci.ics.hyracks.api.dataset.ResultSetId;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.io.IWorkspaceFileFactory;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.partitions.ResultSetPartitionId;
import edu.uci.ics.hyracks.control.nc.dataset.DatasetMemoryManager;
import edu.uci.ics.hyracks.control.nc.dataset.ResultState;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatasetPartitionWriter
implements IFrameWriter {
    private static final Logger LOGGER = Logger.getLogger(DatasetPartitionWriter.class.getName());
    private final IDatasetPartitionManager manager;
    private final JobId jobId;
    private final ResultSetId resultSetId;
    private final boolean asyncMode;
    private final int partition;
    private final DatasetMemoryManager datasetMemoryManager;
    private final ResultSetPartitionId resultSetPartitionId;
    private final ResultState resultState;

    public DatasetPartitionWriter(IHyracksTaskContext ctx, IDatasetPartitionManager manager, JobId jobId, ResultSetId rsId, boolean asyncMode, int partition, DatasetMemoryManager datasetMemoryManager, IWorkspaceFileFactory fileFactory) {
        this.manager = manager;
        this.jobId = jobId;
        this.resultSetId = rsId;
        this.asyncMode = asyncMode;
        this.partition = partition;
        this.datasetMemoryManager = datasetMemoryManager;
        this.resultSetPartitionId = new ResultSetPartitionId(jobId, rsId, partition);
        this.resultState = new ResultState(this.resultSetPartitionId, asyncMode, ctx.getIOManager(), fileFactory, ctx.getFrameSize());
    }

    public ResultState getResultState() {
        return this.resultState;
    }

    public void open() {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("open(" + this.partition + ")");
        }
        this.resultState.open();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        if (this.datasetMemoryManager == null) {
            this.resultState.write(buffer);
        } else {
            this.resultState.write(this.datasetMemoryManager, buffer);
        }
    }

    public void fail() throws HyracksDataException {
        try {
            this.resultState.closeAndDelete();
            this.resultState.abort();
            this.manager.reportPartitionFailure(this.jobId, this.resultSetId, this.partition);
        }
        catch (HyracksException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void close() throws HyracksDataException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("close(" + this.partition + ")");
        }
        try {
            this.resultState.close();
            this.manager.reportPartitionWriteCompletion(this.jobId, this.resultSetId, this.partition);
        }
        catch (HyracksException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }
}

