/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.dataset;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.comm.channels.NetworkOutputChannel;
import edu.uci.ics.hyracks.control.nc.dataset.DatasetMemoryManager;
import edu.uci.ics.hyracks.control.nc.dataset.DatasetPartitionManager;
import edu.uci.ics.hyracks.control.nc.dataset.ResultState;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatasetPartitionReader {
    private static final Logger LOGGER = Logger.getLogger(DatasetPartitionReader.class.getName());
    private final DatasetPartitionManager datasetPartitionManager;
    private final DatasetMemoryManager datasetMemoryManager;
    private final Executor executor;
    private final ResultState resultState;

    public DatasetPartitionReader(DatasetPartitionManager datasetPartitionManager, DatasetMemoryManager datasetMemoryManager, Executor executor, ResultState resultState) {
        this.datasetPartitionManager = datasetPartitionManager;
        this.datasetMemoryManager = datasetMemoryManager;
        this.executor = executor;
        this.resultState = resultState;
    }

    public void writeTo(final IFrameWriter writer) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NetworkOutputChannel channel = (NetworkOutputChannel)writer;
                channel.setFrameSize(DatasetPartitionReader.this.resultState.getFrameSize());
                try {
                    DatasetPartitionReader.this.resultState.readOpen();
                    channel.open();
                    try {
                        long offset = 0L;
                        ByteBuffer buffer = ByteBuffer.allocate(DatasetPartitionReader.this.resultState.getFrameSize());
                        while (true) {
                            buffer.clear();
                            long size = this.read(offset, buffer);
                            if (size <= 0L) {
                                break;
                            }
                            if (size < (long)buffer.limit()) {
                                throw new HyracksDataException("Premature end of file - readSize: " + size + " buffer limit: " + buffer.limit());
                            }
                            offset += size;
                            buffer.flip();
                            channel.nextFrame(buffer);
                        }
                    }
                    finally {
                        channel.close();
                        DatasetPartitionReader.this.resultState.readClose();
                        if (!DatasetPartitionReader.this.resultState.getAsyncMode()) {
                            DatasetPartitionReader.this.datasetPartitionManager.removePartition(DatasetPartitionReader.this.resultState.getResultSetPartitionId().getJobId(), DatasetPartitionReader.this.resultState.getResultSetPartitionId().getResultSetId(), DatasetPartitionReader.this.resultState.getResultSetPartitionId().getPartition());
                        }
                    }
                }
                catch (HyracksDataException e) {
                    throw new RuntimeException(e);
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("result reading successful(" + DatasetPartitionReader.this.resultState.getResultSetPartitionId() + ")");
                }
            }

            private long read(long offset, ByteBuffer buffer) throws HyracksDataException {
                if (DatasetPartitionReader.this.datasetMemoryManager == null) {
                    return DatasetPartitionReader.this.resultState.read(offset, buffer);
                }
                return DatasetPartitionReader.this.resultState.read(DatasetPartitionReader.this.datasetMemoryManager, offset, buffer);
            }
        });
    }
}

