/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc.dataset;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataset.IDatasetManager;
import edu.uci.ics.hyracks.api.dataset.IDatasetPartitionManager;
import edu.uci.ics.hyracks.api.dataset.IDatasetStateRecord;
import edu.uci.ics.hyracks.api.dataset.ResultSetId;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.io.IWorkspaceFileFactory;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.common.dataset.ResultStateSweeper;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import edu.uci.ics.hyracks.control.nc.dataset.DatasetMemoryManager;
import edu.uci.ics.hyracks.control.nc.dataset.DatasetPartitionReader;
import edu.uci.ics.hyracks.control.nc.dataset.DatasetPartitionWriter;
import edu.uci.ics.hyracks.control.nc.dataset.ResultState;
import edu.uci.ics.hyracks.control.nc.io.IOManager;
import edu.uci.ics.hyracks.control.nc.io.WorkspaceFileFactory;
import edu.uci.ics.hyracks.control.nc.resources.DefaultDeallocatableRegistry;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

public class DatasetPartitionManager
implements IDatasetPartitionManager {
    private static final Logger LOGGER = Logger.getLogger(DatasetPartitionManager.class.getName());
    private final NodeControllerService ncs;
    private final Executor executor;
    private final Map<JobId, IDatasetStateRecord> partitionResultStateMap;
    private final DefaultDeallocatableRegistry deallocatableRegistry;
    private final IWorkspaceFileFactory fileFactory;
    private final DatasetMemoryManager datasetMemoryManager;

    public DatasetPartitionManager(NodeControllerService ncs, Executor executor, int availableMemory, long resultTTL, long resultSweepThreshold) {
        this.ncs = ncs;
        this.executor = executor;
        this.deallocatableRegistry = new DefaultDeallocatableRegistry();
        this.fileFactory = new WorkspaceFileFactory(this.deallocatableRegistry, (IOManager)ncs.getRootContext().getIOManager());
        this.datasetMemoryManager = availableMemory >= DatasetMemoryManager.getPageSize() ? new DatasetMemoryManager(availableMemory) : null;
        this.partitionResultStateMap = new LinkedHashMap<JobId, IDatasetStateRecord>();
        executor.execute((Runnable)new ResultStateSweeper((IDatasetManager)this, resultTTL, resultSweepThreshold));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFrameWriter createDatasetPartitionWriter(IHyracksTaskContext ctx, ResultSetId rsId, boolean orderedResult, boolean asyncMode, int partition, int nPartitions) throws HyracksException {
        DatasetPartitionWriter dpw = null;
        JobId jobId = ctx.getJobletContext().getJobId();
        try {
            DatasetPartitionManager datasetPartitionManager = this;
            synchronized (datasetPartitionManager) {
                ResultState[] resultStates;
                this.ncs.getClusterController().registerResultPartitionLocation(jobId, rsId, orderedResult, partition, nPartitions, this.ncs.getDatasetNetworkManager().getNetworkAddress());
                dpw = new DatasetPartitionWriter(ctx, this, jobId, rsId, asyncMode, partition, this.datasetMemoryManager, this.fileFactory);
                ResultSetMap rsIdMap = (ResultSetMap)this.partitionResultStateMap.get(jobId);
                if (rsIdMap == null) {
                    rsIdMap = new ResultSetMap();
                    this.partitionResultStateMap.put(jobId, rsIdMap);
                }
                if ((resultStates = (ResultState[])rsIdMap.get(rsId)) == null) {
                    resultStates = new ResultState[nPartitions];
                    rsIdMap.put(rsId, resultStates);
                }
                resultStates[partition] = dpw.getResultState();
            }
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
        LOGGER.fine("Initialized partition writer: JobId: " + jobId + ":partition: " + partition);
        return dpw;
    }

    public void reportPartitionWriteCompletion(JobId jobId, ResultSetId rsId, int partition) throws HyracksException {
        try {
            LOGGER.fine("Reporting partition write completion: JobId: " + jobId + ": ResultSetId: " + rsId + ":partition: " + partition);
            this.ncs.getClusterController().reportResultPartitionWriteCompletion(jobId, rsId, partition);
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public void reportPartitionFailure(JobId jobId, ResultSetId rsId, int partition) throws HyracksException {
        try {
            LOGGER.info("Reporting partition failure: JobId: " + jobId + ": ResultSetId: " + rsId + ":partition: " + partition);
            this.ncs.getClusterController().reportResultPartitionFailure(jobId, rsId, partition);
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDatasetPartitionReader(JobId jobId, ResultSetId resultSetId, int partition, IFrameWriter writer) throws HyracksException {
        ResultState resultState;
        DatasetPartitionManager datasetPartitionManager = this;
        synchronized (datasetPartitionManager) {
            ResultSetMap rsIdMap = (ResultSetMap)this.partitionResultStateMap.get(jobId);
            if (rsIdMap == null) {
                throw new HyracksException("Unknown JobId " + jobId);
            }
            ResultState[] resultStates = (ResultState[])rsIdMap.get(resultSetId);
            if (resultStates == null) {
                throw new HyracksException("Unknown JobId: " + jobId + " ResultSetId: " + resultSetId);
            }
            resultState = resultStates[partition];
            if (resultState == null) {
                throw new HyracksException("No DatasetPartitionWriter for partition " + partition);
            }
        }
        DatasetPartitionReader dpr = new DatasetPartitionReader(this, this.datasetMemoryManager, this.executor, resultState);
        dpr.writeTo(writer);
        LOGGER.fine("Initialized partition reader: JobId: " + jobId + ":ResultSetId: " + resultSetId + ":partition: " + partition);
    }

    public synchronized void removePartition(JobId jobId, ResultSetId resultSetId, int partition) {
        ResultSetMap rsIdMap = (ResultSetMap)this.partitionResultStateMap.get(jobId);
        if (rsIdMap != null) {
            ResultState[] resultStates = (ResultState[])rsIdMap.get(resultSetId);
            if (resultStates != null) {
                ResultState state = resultStates[partition];
                if (state != null) {
                    state.closeAndDelete();
                    LOGGER.fine("Removing partition: " + partition + " for JobId: " + jobId);
                }
                resultStates[partition] = null;
                boolean stateEmpty = true;
                for (int i = 0; i < resultStates.length; ++i) {
                    if (resultStates[i] == null) continue;
                    stateEmpty = false;
                    break;
                }
                if (stateEmpty) {
                    rsIdMap.remove(resultSetId);
                }
            }
            if (rsIdMap.isEmpty()) {
                this.partitionResultStateMap.remove(jobId);
            }
        }
    }

    public synchronized void abortReader(JobId jobId) {
        ResultSetMap rsIdMap = (ResultSetMap)this.partitionResultStateMap.get(jobId);
        if (rsIdMap == null) {
            return;
        }
        for (ResultSetId rsId : rsIdMap.keySet()) {
            ResultState[] resultStates = (ResultState[])rsIdMap.get(rsId);
            if (resultStates == null) continue;
            for (ResultState state : resultStates) {
                if (state == null) continue;
                state.abort();
            }
        }
    }

    public IWorkspaceFileFactory getFileFactory() {
        return this.fileFactory;
    }

    public synchronized void close() {
        for (Map.Entry<JobId, IDatasetStateRecord> entry : this.partitionResultStateMap.entrySet()) {
            this.deinit(entry.getKey());
        }
        this.deallocatableRegistry.close();
    }

    public Map<JobId, IDatasetStateRecord> getStateMap() {
        return this.partitionResultStateMap;
    }

    public void deinitState(JobId jobId) {
        this.deinit(jobId);
        this.partitionResultStateMap.remove(jobId);
    }

    private void deinit(JobId jobId) {
        ResultSetMap rsIdMap = (ResultSetMap)this.partitionResultStateMap.get(jobId);
        if (rsIdMap != null) {
            for (ResultSetId rsId : rsIdMap.keySet()) {
                ResultState[] resultStates = (ResultState[])rsIdMap.get(rsId);
                if (resultStates == null) continue;
                for (int i = 0; i < resultStates.length; ++i) {
                    ResultState state = resultStates[i];
                    if (state == null) continue;
                    state.closeAndDelete();
                    LOGGER.fine("Removing partition: " + i + " for JobId: " + jobId);
                }
            }
        }
    }

    private class ResultSetMap
    extends HashMap<ResultSetId, ResultState[]>
    implements IDatasetStateRecord {
        private static final long serialVersionUID = 1L;
        long timestamp = System.currentTimeMillis();

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

