/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc;

import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.comm.IPartitionCollector;
import edu.uci.ics.hyracks.api.context.IHyracksJobletContext;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.TaskAttemptId;
import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.dataset.IDatasetPartitionManager;
import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.api.io.IIOManager;
import edu.uci.ics.hyracks.api.io.IWorkspaceFileFactory;
import edu.uci.ics.hyracks.api.job.IOperatorEnvironment;
import edu.uci.ics.hyracks.api.job.profiling.counters.ICounter;
import edu.uci.ics.hyracks.api.job.profiling.counters.ICounterContext;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.api.resources.IDeallocatable;
import edu.uci.ics.hyracks.api.resources.IDeallocatableRegistry;
import edu.uci.ics.hyracks.control.common.job.PartitionState;
import edu.uci.ics.hyracks.control.common.job.profiling.counters.Counter;
import edu.uci.ics.hyracks.control.common.job.profiling.om.PartitionProfile;
import edu.uci.ics.hyracks.control.common.job.profiling.om.TaskProfile;
import edu.uci.ics.hyracks.control.common.utils.ExceptionUtils;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import edu.uci.ics.hyracks.control.nc.Joblet;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import edu.uci.ics.hyracks.control.nc.io.IOManager;
import edu.uci.ics.hyracks.control.nc.io.WorkspaceFileFactory;
import edu.uci.ics.hyracks.control.nc.resources.DefaultDeallocatableRegistry;
import edu.uci.ics.hyracks.control.nc.work.NotifyTaskCompleteWork;
import edu.uci.ics.hyracks.control.nc.work.NotifyTaskFailureWork;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;

public class Task
implements IHyracksTaskContext,
ICounterContext,
Runnable {
    private final Joblet joblet;
    private final TaskAttemptId taskAttemptId;
    private final String displayName;
    private final Executor executor;
    private final IWorkspaceFileFactory fileFactory;
    private final DefaultDeallocatableRegistry deallocatableRegistry;
    private final Map<String, Counter> counterMap;
    private final IOperatorEnvironment opEnv;
    private final Map<PartitionId, PartitionProfile> partitionSendProfile;
    private final Set<Thread> pendingThreads;
    private IPartitionCollector[] collectors;
    private IOperatorNodePushable operator;
    private final List<Exception> exceptions;
    private List<Throwable> caughtExceptions;
    private volatile boolean aborted;
    private NodeControllerService ncs;

    public Task(Joblet joblet, TaskAttemptId taskId, String displayName, Executor executor, NodeControllerService ncs) {
        this.joblet = joblet;
        this.taskAttemptId = taskId;
        this.displayName = displayName;
        this.executor = executor;
        this.fileFactory = new WorkspaceFileFactory((IDeallocatableRegistry)this, (IOManager)joblet.getIOManager());
        this.deallocatableRegistry = new DefaultDeallocatableRegistry();
        this.counterMap = new HashMap<String, Counter>();
        this.opEnv = joblet.getEnvironment();
        this.partitionSendProfile = new Hashtable<PartitionId, PartitionProfile>();
        this.pendingThreads = new LinkedHashSet<Thread>();
        this.exceptions = new ArrayList<Exception>();
        this.ncs = ncs;
    }

    public void setTaskRuntime(IPartitionCollector[] collectors, IOperatorNodePushable operator) {
        this.collectors = collectors;
        this.operator = operator;
    }

    public ByteBuffer allocateFrame() throws HyracksDataException {
        return this.joblet.allocateFrame();
    }

    public void deallocateFrames(int frameCount) {
        this.joblet.deallocateFrames(frameCount);
    }

    public int getFrameSize() {
        return this.joblet.getFrameSize();
    }

    public IIOManager getIOManager() {
        return this.joblet.getIOManager();
    }

    public FileReference createUnmanagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createUnmanagedWorkspaceFile(prefix);
    }

    public FileReference createManagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createManagedWorkspaceFile(prefix);
    }

    public void registerDeallocatable(IDeallocatable deallocatable) {
        this.deallocatableRegistry.registerDeallocatable(deallocatable);
    }

    public void close() {
        this.deallocatableRegistry.close();
    }

    public IHyracksJobletContext getJobletContext() {
        return this.joblet;
    }

    public TaskAttemptId getTaskAttemptId() {
        return this.taskAttemptId;
    }

    public ICounter getCounter(String name, boolean create) {
        Counter counter = this.counterMap.get(name);
        if (counter == null && create) {
            counter = new Counter(name);
            this.counterMap.put(name, counter);
        }
        return counter;
    }

    public ICounterContext getCounterContext() {
        return this;
    }

    public Joblet getJoblet() {
        return this.joblet;
    }

    public Map<PartitionId, PartitionProfile> getPartitionSendProfile() {
        return this.partitionSendProfile;
    }

    public synchronized void dumpProfile(TaskProfile tProfile) {
        Map dumpMap = tProfile.getCounters();
        for (Counter c : this.counterMap.values()) {
            dumpMap.put(c.getName(), c.get());
        }
    }

    public void setPartitionSendProfile(PartitionProfile profile) {
        this.partitionSendProfile.put(profile.getPartitionId(), profile);
    }

    public void start() throws HyracksException {
        this.aborted = false;
        this.executor.execute(this);
    }

    public synchronized void abort() {
        this.aborted = true;
        for (IPartitionCollector c : this.collectors) {
            c.abort();
        }
        for (Thread t : this.pendingThreads) {
            t.interrupt();
        }
    }

    private synchronized void addPendingThread(Thread t) {
        this.pendingThreads.add(t);
    }

    private synchronized void removePendingThread(Thread t) {
        this.pendingThreads.remove(t);
        if (this.pendingThreads.isEmpty()) {
            this.notifyAll();
        }
    }

    public synchronized void waitForCompletion() throws InterruptedException {
        while (!this.pendingThreads.isEmpty()) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NodeControllerService ncs;
        Thread ct = Thread.currentThread();
        String threadName = ct.getName();
        this.addPendingThread(ct);
        try {
            block14: {
                ct.setName(this.displayName + ":" + this.taskAttemptId + ":" + 0);
                this.operator.initialize();
                try {
                    if (this.collectors.length <= 0) break block14;
                    final Semaphore sem = new Semaphore(this.collectors.length - 1);
                    int i = 1;
                    while (i < this.collectors.length) {
                        final IPartitionCollector collector = this.collectors[i];
                        final IFrameWriter writer = this.operator.getInputFrameWriter(i);
                        sem.acquire();
                        final int cIdx = i++;
                        this.executor.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (Task.this.aborted) {
                                    return;
                                }
                                Thread thread = Thread.currentThread();
                                Task.this.addPendingThread(thread);
                                String oldName = thread.getName();
                                thread.setName(Task.this.displayName + ":" + Task.this.taskAttemptId + ":" + cIdx);
                                thread.setPriority(1);
                                try {
                                    Task.this.pushFrames(collector, writer);
                                }
                                catch (HyracksDataException e) {
                                    Task task = Task.this;
                                    synchronized (task) {
                                        Task.this.exceptions.add(e);
                                    }
                                }
                                finally {
                                    thread.setName(oldName);
                                    sem.release();
                                    Task.this.removePendingThread(thread);
                                }
                            }
                        });
                    }
                    try {
                        this.pushFrames(this.collectors[0], this.operator.getInputFrameWriter(0));
                    }
                    finally {
                        sem.acquire(this.collectors.length - 1);
                    }
                }
                finally {
                    this.operator.deinitialize();
                }
            }
            ncs = this.joblet.getNodeController();
            ncs.getWorkQueue().schedule((AbstractWork)new NotifyTaskCompleteWork(ncs, this));
        }
        catch (Exception e) {
            this.exceptions.add(e);
        }
        finally {
            ct.setName(threadName);
            this.close();
            this.removePendingThread(ct);
        }
        if (!this.exceptions.isEmpty()) {
            for (Exception e : this.exceptions) {
                e.printStackTrace();
            }
            ncs = this.joblet.getNodeController();
            ExceptionUtils.setNodeIds(this.exceptions, (String)ncs.getId());
            ncs.getWorkQueue().schedule((AbstractWork)new NotifyTaskFailureWork(ncs, this, this.exceptions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushFrames(IPartitionCollector collector, IFrameWriter writer) throws HyracksDataException {
        if (this.aborted) {
            return;
        }
        try {
            collector.open();
            try {
                this.joblet.advertisePartitionRequest(this.taskAttemptId, collector.getRequiredPartitionIds(), collector, PartitionState.STARTED);
                reader.open();
                try (IFrameReader reader = collector.getReader();){
                    writer.open();
                    try {
                        ByteBuffer buffer = this.allocateFrame();
                        while (reader.nextFrame(buffer)) {
                            if (this.aborted) {
                                return;
                            }
                            buffer.flip();
                            writer.nextFrame(buffer);
                            buffer.compact();
                        }
                    }
                    catch (Exception e) {
                        writer.fail();
                        throw e;
                    }
                    finally {
                        writer.close();
                    }
                }
            }
            finally {
                collector.close();
            }
        }
        catch (HyracksException e) {
            throw new HyracksDataException((Throwable)e);
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void setStateObject(IStateObject taskState) {
        this.opEnv.setStateObject(taskState);
    }

    public IStateObject getStateObject(Object id) {
        return this.opEnv.getStateObject(id);
    }

    public IDatasetPartitionManager getDatasetPartitionManager() {
        return this.ncs.getDatasetPartitionManager();
    }

    public void sendApplicationMessageToCC(byte[] message, DeploymentId deploymentId, String nodeId) throws Exception {
        this.ncs.sendApplicationMessageToCC(message, deploymentId, nodeId);
    }
}

