/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc;

import edu.uci.ics.hyracks.api.application.INCApplicationContext;
import edu.uci.ics.hyracks.api.application.INCApplicationEntryPoint;
import edu.uci.ics.hyracks.api.client.NodeControllerInfo;
import edu.uci.ics.hyracks.api.context.IHyracksRootContext;
import edu.uci.ics.hyracks.api.dataset.IDatasetPartitionManager;
import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.io.IODeviceHandle;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.lifecycle.ILifeCycleComponentManager;
import edu.uci.ics.hyracks.api.lifecycle.LifeCycleComponentManager;
import edu.uci.ics.hyracks.control.common.AbstractRemoteService;
import edu.uci.ics.hyracks.control.common.base.IClusterController;
import edu.uci.ics.hyracks.control.common.context.ServerContext;
import edu.uci.ics.hyracks.control.common.controllers.NCConfig;
import edu.uci.ics.hyracks.control.common.controllers.NodeParameters;
import edu.uci.ics.hyracks.control.common.controllers.NodeRegistration;
import edu.uci.ics.hyracks.control.common.heartbeat.HeartbeatData;
import edu.uci.ics.hyracks.control.common.heartbeat.HeartbeatSchema;
import edu.uci.ics.hyracks.control.common.ipc.CCNCFunctions;
import edu.uci.ics.hyracks.control.common.ipc.ClusterControllerRemoteProxy;
import edu.uci.ics.hyracks.control.common.job.profiling.om.JobProfile;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import edu.uci.ics.hyracks.control.common.work.FutureValue;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import edu.uci.ics.hyracks.control.common.work.WorkQueue;
import edu.uci.ics.hyracks.control.nc.Joblet;
import edu.uci.ics.hyracks.control.nc.application.NCApplicationContext;
import edu.uci.ics.hyracks.control.nc.dataset.DatasetPartitionManager;
import edu.uci.ics.hyracks.control.nc.io.IOManager;
import edu.uci.ics.hyracks.control.nc.io.profiling.IIOCounter;
import edu.uci.ics.hyracks.control.nc.io.profiling.IOCounterFactory;
import edu.uci.ics.hyracks.control.nc.net.DatasetNetworkManager;
import edu.uci.ics.hyracks.control.nc.net.NetworkManager;
import edu.uci.ics.hyracks.control.nc.partitions.PartitionManager;
import edu.uci.ics.hyracks.control.nc.resources.memory.MemoryManager;
import edu.uci.ics.hyracks.control.nc.runtime.RootHyracksContext;
import edu.uci.ics.hyracks.control.nc.work.AbortTasksWork;
import edu.uci.ics.hyracks.control.nc.work.ApplicationMessageWork;
import edu.uci.ics.hyracks.control.nc.work.BuildJobProfilesWork;
import edu.uci.ics.hyracks.control.nc.work.CleanupJobletWork;
import edu.uci.ics.hyracks.control.nc.work.DeployBinaryWork;
import edu.uci.ics.hyracks.control.nc.work.ReportPartitionAvailabilityWork;
import edu.uci.ics.hyracks.control.nc.work.StartTasksWork;
import edu.uci.ics.hyracks.control.nc.work.StateDumpWork;
import edu.uci.ics.hyracks.control.nc.work.UnDeployBinaryWork;
import edu.uci.ics.hyracks.ipc.api.IIPCHandle;
import edu.uci.ics.hyracks.ipc.api.IIPCI;
import edu.uci.ics.hyracks.ipc.api.IPCPerformanceCounters;
import edu.uci.ics.hyracks.ipc.api.IPayloadSerializerDeserializer;
import edu.uci.ics.hyracks.ipc.impl.IPCSystem;
import edu.uci.ics.hyracks.net.protocols.muxdemux.MuxDemuxPerformanceCounters;
import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class NodeControllerService
extends AbstractRemoteService {
    private static Logger LOGGER = Logger.getLogger(NodeControllerService.class.getName());
    private static final double MEMORY_FUDGE_FACTOR = 0.8;
    private NCConfig ncConfig;
    private final String id;
    private final IHyracksRootContext ctx;
    private final IPCSystem ipc;
    private final PartitionManager partitionManager;
    private final NetworkManager netManager;
    private IDatasetPartitionManager datasetPartitionManager;
    private DatasetNetworkManager datasetNetworkManager;
    private final WorkQueue queue;
    private final Timer timer;
    private boolean registrationPending;
    private Exception registrationException;
    private IClusterController ccs;
    private final Map<JobId, Joblet> jobletMap;
    private ExecutorService executor;
    private NodeParameters nodeParameters;
    private HeartbeatTask heartbeatTask;
    private final ServerContext serverCtx;
    private NCApplicationContext appCtx;
    private INCApplicationEntryPoint ncAppEntryPoint;
    private final ILifeCycleComponentManager lccm;
    private final MemoryMXBean memoryMXBean;
    private final List<GarbageCollectorMXBean> gcMXBeans;
    private final ThreadMXBean threadMXBean;
    private final RuntimeMXBean runtimeMXBean;
    private final OperatingSystemMXBean osMXBean;
    private final Mutable<FutureValue<Map<String, NodeControllerInfo>>> getNodeControllerInfosAcceptor;
    private final MemoryManager memoryManager;
    private boolean shuttedDown = false;
    private IIOCounter ioCounter;

    public NodeControllerService(NCConfig ncConfig) throws Exception {
        this.ncConfig = ncConfig;
        this.id = ncConfig.nodeId;
        NodeControllerIPCI ipci = new NodeControllerIPCI();
        this.ipc = new IPCSystem(new InetSocketAddress(ncConfig.clusterNetIPAddress, 0), (IIPCI)ipci, (IPayloadSerializerDeserializer)new CCNCFunctions.SerializerDeserializer());
        this.ctx = new RootHyracksContext(this, new IOManager(NodeControllerService.getDevices(ncConfig.ioDevices)));
        if (this.id == null) {
            throw new Exception("id not set");
        }
        this.partitionManager = new PartitionManager(this);
        this.netManager = new NetworkManager(NodeControllerService.getIpAddress(ncConfig.dataIPAddress), this.partitionManager, ncConfig.nNetThreads);
        this.lccm = new LifeCycleComponentManager();
        this.queue = new WorkQueue();
        this.jobletMap = new Hashtable<JobId, Joblet>();
        this.timer = new Timer(true);
        this.serverCtx = new ServerContext(ServerContext.ServerType.NODE_CONTROLLER, new File(new File(NodeControllerService.class.getName()), this.id));
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        this.osMXBean = ManagementFactory.getOperatingSystemMXBean();
        this.registrationPending = true;
        this.getNodeControllerInfosAcceptor = new MutableObject();
        this.memoryManager = new MemoryManager((long)((double)this.memoryMXBean.getHeapMemoryUsage().getMax() * 0.8));
        this.ioCounter = new IOCounterFactory().getIOCounter();
    }

    public IHyracksRootContext getRootContext() {
        return this.ctx;
    }

    public NCApplicationContext getApplicationContext() {
        return this.appCtx;
    }

    public ILifeCycleComponentManager getLifeCycleComponentManager() {
        return this.lccm;
    }

    private static List<IODeviceHandle> getDevices(String ioDevices) {
        ArrayList<IODeviceHandle> devices = new ArrayList<IODeviceHandle>();
        StringTokenizer tok = new StringTokenizer(ioDevices, ",");
        while (tok.hasMoreElements()) {
            String devPath = tok.nextToken().trim();
            devices.add(new IODeviceHandle(new File(devPath), "."));
        }
        return devices;
    }

    private synchronized void setNodeRegistrationResult(NodeParameters parameters, Exception exception) {
        this.nodeParameters = parameters;
        this.registrationException = exception;
        this.registrationPending = false;
        ((Object)((Object)this)).notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, NodeControllerInfo> getNodeControllersInfo() throws Exception {
        FutureValue fv = new FutureValue();
        Mutable<FutureValue<Map<String, NodeControllerInfo>>> mutable = this.getNodeControllerInfosAcceptor;
        synchronized (mutable) {
            while (this.getNodeControllerInfosAcceptor.getValue() != null) {
                this.getNodeControllerInfosAcceptor.wait();
            }
            this.getNodeControllerInfosAcceptor.setValue((Object)fv);
        }
        this.ccs.getNodeControllerInfos();
        return (Map)fv.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNodeControllersInfo(Map<String, NodeControllerInfo> ncInfos) {
        FutureValue fv;
        Mutable<FutureValue<Map<String, NodeControllerInfo>>> mutable = this.getNodeControllerInfosAcceptor;
        synchronized (mutable) {
            fv = (FutureValue)this.getNodeControllerInfosAcceptor.getValue();
            this.getNodeControllerInfosAcceptor.setValue(null);
            this.getNodeControllerInfosAcceptor.notifyAll();
        }
        fv.setValue(ncInfos);
    }

    private void init() throws Exception {
        this.ctx.getIOManager().setExecutor((Executor)this.executor);
        this.datasetPartitionManager = new DatasetPartitionManager(this, this.executor, this.ncConfig.resultManagerMemory, this.ncConfig.resultTTL, this.ncConfig.resultSweepThreshold);
        this.datasetNetworkManager = new DatasetNetworkManager(NodeControllerService.getIpAddress(this.ncConfig.datasetIPAddress), this.datasetPartitionManager, this.ncConfig.nNetThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        LOGGER.log(Level.INFO, "Starting NodeControllerService");
        this.ipc.start();
        this.netManager.start();
        this.startApplication();
        this.init();
        this.datasetNetworkManager.start();
        IIPCHandle ccIPCHandle = this.ipc.getHandle(new InetSocketAddress(this.ncConfig.ccHost, this.ncConfig.ccPort));
        this.ccs = new ClusterControllerRemoteProxy(ccIPCHandle);
        HeartbeatSchema.GarbageCollectorInfo[] gcInfos = new HeartbeatSchema.GarbageCollectorInfo[this.gcMXBeans.size()];
        for (int i = 0; i < gcInfos.length; ++i) {
            gcInfos[i] = new HeartbeatSchema.GarbageCollectorInfo(this.gcMXBeans.get(i).getName());
        }
        HeartbeatSchema hbSchema = new HeartbeatSchema(gcInfos);
        this.ccs.registerNode(new NodeRegistration(this.ipc.getSocketAddress(), this.id, this.ncConfig, this.netManager.getNetworkAddress(), this.datasetNetworkManager.getNetworkAddress(), this.osMXBean.getName(), this.osMXBean.getArch(), this.osMXBean.getVersion(), this.osMXBean.getAvailableProcessors(), this.runtimeMXBean.getVmName(), this.runtimeMXBean.getVmVersion(), this.runtimeMXBean.getVmVendor(), this.runtimeMXBean.getClassPath(), this.runtimeMXBean.getLibraryPath(), this.runtimeMXBean.getBootClassPath(), this.runtimeMXBean.getInputArguments(), this.runtimeMXBean.getSystemProperties(), hbSchema));
        NodeControllerService nodeControllerService = this;
        synchronized (nodeControllerService) {
            while (this.registrationPending) {
                ((Object)((Object)this)).wait();
            }
        }
        if (this.registrationException != null) {
            throw this.registrationException;
        }
        this.appCtx.setDistributedState(this.nodeParameters.getDistributedState());
        this.queue.start();
        this.heartbeatTask = new HeartbeatTask(this.ccs);
        this.timer.schedule((TimerTask)this.heartbeatTask, 0L, (long)this.nodeParameters.getHeartbeatPeriod());
        if (this.nodeParameters.getProfileDumpPeriod() > 0) {
            this.timer.schedule((TimerTask)new ProfileDumpTask(this.ccs), 0L, (long)this.nodeParameters.getProfileDumpPeriod());
        }
        LOGGER.log(Level.INFO, "Started NodeControllerService");
        if (this.ncAppEntryPoint != null) {
            this.ncAppEntryPoint.notifyStartupComplete();
        }
        Runtime.getRuntime().addShutdownHook(new JVMShutdownHook(this));
    }

    private void startApplication() throws Exception {
        this.appCtx = new NCApplicationContext(this.serverCtx, this.ctx, this.id, this.memoryManager, this.lccm);
        String className = this.ncConfig.appNCMainClass;
        if (className != null) {
            Class<?> c = Class.forName(className);
            this.ncAppEntryPoint = (INCApplicationEntryPoint)c.newInstance();
            String[] args = this.ncConfig.appArgs == null ? new String[]{} : this.ncConfig.appArgs.toArray(new String[this.ncConfig.appArgs.size()]);
            this.ncAppEntryPoint.start((INCApplicationContext)this.appCtx, args);
        }
        this.executor = Executors.newCachedThreadPool(this.appCtx.getThreadFactory());
    }

    public synchronized void stop() throws Exception {
        if (!this.shuttedDown) {
            LOGGER.log(Level.INFO, "Stopping NodeControllerService");
            this.executor.shutdownNow();
            this.partitionManager.close();
            this.datasetPartitionManager.close();
            this.heartbeatTask.cancel();
            this.netManager.stop();
            this.datasetNetworkManager.stop();
            this.queue.stop();
            if (this.ncAppEntryPoint != null) {
                this.ncAppEntryPoint.stop();
            }
            LOGGER.log(Level.INFO, "Stopped NodeControllerService");
            this.shuttedDown = true;
        }
    }

    public String getId() {
        return this.id;
    }

    public ServerContext getServerContext() {
        return this.serverCtx;
    }

    public Map<JobId, Joblet> getJobletMap() {
        return this.jobletMap;
    }

    public NetworkManager getNetworkManager() {
        return this.netManager;
    }

    public DatasetNetworkManager getDatasetNetworkManager() {
        return this.datasetNetworkManager;
    }

    public PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    public IClusterController getClusterController() {
        return this.ccs;
    }

    public NodeParameters getNodeParameters() {
        return this.nodeParameters;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public NCConfig getConfiguration() {
        return this.ncConfig;
    }

    public WorkQueue getWorkQueue() {
        return this.queue;
    }

    private static InetAddress getIpAddress(String ipaddrStr) throws Exception {
        ipaddrStr = ipaddrStr.trim();
        Pattern pattern = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
        Matcher m = pattern.matcher(ipaddrStr);
        if (!m.matches()) {
            throw new Exception(MessageFormat.format("Connection Manager IP Address String %s does is not a valid IP Address.", ipaddrStr));
        }
        byte[] ipBytes = new byte[]{(byte)Integer.parseInt(m.group(1)), (byte)Integer.parseInt(m.group(2)), (byte)Integer.parseInt(m.group(3)), (byte)Integer.parseInt(m.group(4))};
        return InetAddress.getByAddress(ipBytes);
    }

    public void sendApplicationMessageToCC(byte[] data, DeploymentId deploymentId, String nodeId) throws Exception {
        this.ccs.sendApplicationMessageToCC(data, deploymentId, nodeId);
    }

    public IDatasetPartitionManager getDatasetPartitionManager() {
        return this.datasetPartitionManager;
    }

    private static class JVMShutdownHook
    extends Thread {
        private final NodeControllerService nodeControllerService;

        public JVMShutdownHook(NodeControllerService ncAppEntryPoint) {
            this.nodeControllerService = ncAppEntryPoint;
        }

        @Override
        public void run() {
            block3: {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Shutdown hook in progress");
                }
                try {
                    this.nodeControllerService.stop();
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                    LOGGER.warning("Exception in executing shutdown hook" + e);
                }
            }
        }
    }

    private final class NodeControllerIPCI
    implements IIPCI {
        private NodeControllerIPCI() {
        }

        public void deliverIncomingMessage(IIPCHandle handle, long mid, long rmid, Object payload, Exception exception) {
            CCNCFunctions.Function fn = (CCNCFunctions.Function)payload;
            switch (fn.getFunctionId()) {
                case SEND_APPLICATION_MESSAGE: {
                    CCNCFunctions.SendApplicationMessageFunction amf = (CCNCFunctions.SendApplicationMessageFunction)fn;
                    NodeControllerService.this.queue.schedule((AbstractWork)new ApplicationMessageWork(NodeControllerService.this, amf.getMessage(), amf.getDeploymentId(), amf.getNodeId()));
                    return;
                }
                case START_TASKS: {
                    CCNCFunctions.StartTasksFunction stf = (CCNCFunctions.StartTasksFunction)fn;
                    NodeControllerService.this.queue.schedule((AbstractWork)new StartTasksWork(NodeControllerService.this, stf.getDeploymentId(), stf.getJobId(), stf.getPlanBytes(), stf.getTaskDescriptors(), stf.getConnectorPolicies(), stf.getFlags()));
                    return;
                }
                case ABORT_TASKS: {
                    CCNCFunctions.AbortTasksFunction atf = (CCNCFunctions.AbortTasksFunction)fn;
                    NodeControllerService.this.queue.schedule((AbstractWork)new AbortTasksWork(NodeControllerService.this, atf.getJobId(), atf.getTasks()));
                    return;
                }
                case CLEANUP_JOBLET: {
                    CCNCFunctions.CleanupJobletFunction cjf = (CCNCFunctions.CleanupJobletFunction)fn;
                    NodeControllerService.this.queue.schedule((AbstractWork)new CleanupJobletWork(NodeControllerService.this, cjf.getJobId(), cjf.getStatus()));
                    return;
                }
                case REPORT_PARTITION_AVAILABILITY: {
                    CCNCFunctions.ReportPartitionAvailabilityFunction rpaf = (CCNCFunctions.ReportPartitionAvailabilityFunction)fn;
                    NodeControllerService.this.queue.schedule((AbstractWork)new ReportPartitionAvailabilityWork(NodeControllerService.this, rpaf.getPartitionId(), rpaf.getNetworkAddress()));
                    return;
                }
                case NODE_REGISTRATION_RESULT: {
                    CCNCFunctions.NodeRegistrationResult nrrf = (CCNCFunctions.NodeRegistrationResult)fn;
                    NodeControllerService.this.setNodeRegistrationResult(nrrf.getNodeParameters(), nrrf.getException());
                    return;
                }
                case GET_NODE_CONTROLLERS_INFO_RESPONSE: {
                    CCNCFunctions.GetNodeControllersInfoResponseFunction gncirf = (CCNCFunctions.GetNodeControllersInfoResponseFunction)fn;
                    NodeControllerService.this.setNodeControllersInfo(gncirf.getNodeControllerInfos());
                    return;
                }
                case DEPLOY_BINARY: {
                    CCNCFunctions.DeployBinaryFunction ndbf = (CCNCFunctions.DeployBinaryFunction)fn;
                    NodeControllerService.this.queue.schedule((AbstractWork)new DeployBinaryWork(NodeControllerService.this, ndbf.getDeploymentId(), ndbf.getBinaryURLs()));
                    return;
                }
                case UNDEPLOY_BINARY: {
                    CCNCFunctions.UnDeployBinaryFunction ndbf = (CCNCFunctions.UnDeployBinaryFunction)fn;
                    NodeControllerService.this.queue.schedule((AbstractWork)new UnDeployBinaryWork(NodeControllerService.this, ndbf.getDeploymentId()));
                    return;
                }
                case STATE_DUMP_REQUEST: {
                    CCNCFunctions.StateDumpRequestFunction dsrf = (CCNCFunctions.StateDumpRequestFunction)fn;
                    NodeControllerService.this.queue.schedule((AbstractWork)new StateDumpWork(NodeControllerService.this, dsrf.getStateDumpId()));
                    return;
                }
            }
            throw new IllegalArgumentException("Unknown function: " + fn.getFunctionId());
        }
    }

    private class ProfileDumpTask
    extends TimerTask {
        private IClusterController cc;

        public ProfileDumpTask(IClusterController cc) {
            this.cc = cc;
        }

        @Override
        public void run() {
            try {
                FutureValue fv = new FutureValue();
                BuildJobProfilesWork bjpw = new BuildJobProfilesWork(NodeControllerService.this, (FutureValue<List<JobProfile>>)fv);
                NodeControllerService.this.queue.scheduleAndSync((SynchronizableWork)bjpw);
                List profiles = (List)fv.get();
                if (!profiles.isEmpty()) {
                    this.cc.reportProfile(NodeControllerService.this.id, profiles);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class HeartbeatTask
    extends TimerTask {
        private IClusterController cc;
        private final HeartbeatData hbData;

        public HeartbeatTask(IClusterController cc) {
            this.cc = cc;
            this.hbData = new HeartbeatData();
            this.hbData.gcCollectionCounts = new long[NodeControllerService.this.gcMXBeans.size()];
            this.hbData.gcCollectionTimes = new long[NodeControllerService.this.gcMXBeans.size()];
        }

        @Override
        public void run() {
            MemoryUsage heapUsage = NodeControllerService.this.memoryMXBean.getHeapMemoryUsage();
            this.hbData.heapInitSize = heapUsage.getInit();
            this.hbData.heapUsedSize = heapUsage.getUsed();
            this.hbData.heapCommittedSize = heapUsage.getCommitted();
            this.hbData.heapMaxSize = heapUsage.getMax();
            MemoryUsage nonheapUsage = NodeControllerService.this.memoryMXBean.getNonHeapMemoryUsage();
            this.hbData.nonheapInitSize = nonheapUsage.getInit();
            this.hbData.nonheapUsedSize = nonheapUsage.getUsed();
            this.hbData.nonheapCommittedSize = nonheapUsage.getCommitted();
            this.hbData.nonheapMaxSize = nonheapUsage.getMax();
            this.hbData.threadCount = NodeControllerService.this.threadMXBean.getThreadCount();
            this.hbData.peakThreadCount = NodeControllerService.this.threadMXBean.getPeakThreadCount();
            this.hbData.totalStartedThreadCount = NodeControllerService.this.threadMXBean.getTotalStartedThreadCount();
            this.hbData.systemLoadAverage = NodeControllerService.this.osMXBean.getSystemLoadAverage();
            int gcN = NodeControllerService.this.gcMXBeans.size();
            for (int i = 0; i < gcN; ++i) {
                GarbageCollectorMXBean gcMXBean = (GarbageCollectorMXBean)NodeControllerService.this.gcMXBeans.get(i);
                this.hbData.gcCollectionCounts[i] = gcMXBean.getCollectionCount();
                this.hbData.gcCollectionTimes[i] = gcMXBean.getCollectionTime();
            }
            MuxDemuxPerformanceCounters netPC = NodeControllerService.this.netManager.getPerformanceCounters();
            this.hbData.netPayloadBytesRead = netPC.getPayloadBytesRead();
            this.hbData.netPayloadBytesWritten = netPC.getPayloadBytesWritten();
            this.hbData.netSignalingBytesRead = netPC.getSignalingBytesRead();
            this.hbData.netSignalingBytesWritten = netPC.getSignalingBytesWritten();
            MuxDemuxPerformanceCounters datasetNetPC = NodeControllerService.this.datasetNetworkManager.getPerformanceCounters();
            this.hbData.datasetNetPayloadBytesRead = datasetNetPC.getPayloadBytesRead();
            this.hbData.datasetNetPayloadBytesWritten = datasetNetPC.getPayloadBytesWritten();
            this.hbData.datasetNetSignalingBytesRead = datasetNetPC.getSignalingBytesRead();
            this.hbData.datasetNetSignalingBytesWritten = datasetNetPC.getSignalingBytesWritten();
            IPCPerformanceCounters ipcPC = NodeControllerService.this.ipc.getPerformanceCounters();
            this.hbData.ipcMessagesSent = ipcPC.getMessageSentCount();
            this.hbData.ipcMessageBytesSent = ipcPC.getMessageBytesSent();
            this.hbData.ipcMessagesReceived = ipcPC.getMessageReceivedCount();
            this.hbData.ipcMessageBytesReceived = ipcPC.getMessageBytesReceived();
            this.hbData.diskReads = NodeControllerService.this.ioCounter.getReads();
            this.hbData.diskWrites = NodeControllerService.this.ioCounter.getWrites();
            try {
                this.cc.nodeHeartbeat(NodeControllerService.this.id, this.hbData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

