/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc;

import edu.uci.ics.hyracks.control.common.controllers.NCConfig;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.args4j.CmdLineParser;

public class NCDriver {
    private static final Logger LOGGER = Logger.getLogger(NCDriver.class.getName());

    public static void main(String[] args) throws Exception {
        try {
            NCConfig ncConfig = new NCConfig();
            CmdLineParser cp = new CmdLineParser((Object)ncConfig);
            try {
                cp.parseArgument(args);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                cp.printUsage((OutputStream)System.err);
                return;
            }
            final NodeControllerService nService = new NodeControllerService(ncConfig);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.severe("Setting uncaught exception handler " + nService.getLifeCycleComponentManager());
            }
            Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)nService.getLifeCycleComponentManager());
            nService.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        nService.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
    }
}

