/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.nc;

import edu.uci.ics.hyracks.api.application.IApplicationContext;
import edu.uci.ics.hyracks.api.application.INCApplicationContext;
import edu.uci.ics.hyracks.api.comm.IPartitionCollector;
import edu.uci.ics.hyracks.api.comm.PartitionChannel;
import edu.uci.ics.hyracks.api.context.IHyracksJobletContext;
import edu.uci.ics.hyracks.api.dataflow.TaskAttemptId;
import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.api.io.IIOManager;
import edu.uci.ics.hyracks.api.io.IWorkspaceFileFactory;
import edu.uci.ics.hyracks.api.job.ActivityClusterGraph;
import edu.uci.ics.hyracks.api.job.IGlobalJobDataFactory;
import edu.uci.ics.hyracks.api.job.IJobletEventListener;
import edu.uci.ics.hyracks.api.job.IJobletEventListenerFactory;
import edu.uci.ics.hyracks.api.job.IOperatorEnvironment;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.job.JobStatus;
import edu.uci.ics.hyracks.api.job.profiling.counters.ICounter;
import edu.uci.ics.hyracks.api.job.profiling.counters.ICounterContext;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.api.resources.IDeallocatable;
import edu.uci.ics.hyracks.api.resources.IDeallocatableRegistry;
import edu.uci.ics.hyracks.control.common.deployment.DeploymentUtils;
import edu.uci.ics.hyracks.control.common.job.PartitionRequest;
import edu.uci.ics.hyracks.control.common.job.PartitionState;
import edu.uci.ics.hyracks.control.common.job.profiling.counters.Counter;
import edu.uci.ics.hyracks.control.common.job.profiling.om.JobletProfile;
import edu.uci.ics.hyracks.control.common.job.profiling.om.PartitionProfile;
import edu.uci.ics.hyracks.control.common.job.profiling.om.TaskProfile;
import edu.uci.ics.hyracks.control.nc.NodeControllerService;
import edu.uci.ics.hyracks.control.nc.Task;
import edu.uci.ics.hyracks.control.nc.io.IOManager;
import edu.uci.ics.hyracks.control.nc.io.WorkspaceFileFactory;
import edu.uci.ics.hyracks.control.nc.resources.DefaultDeallocatableRegistry;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class Joblet
implements IHyracksJobletContext,
ICounterContext {
    private static final Logger LOGGER = Logger.getLogger(Joblet.class.getName());
    private final NodeControllerService nodeController;
    private final INCApplicationContext appCtx;
    private final DeploymentId deploymentId;
    private final JobId jobId;
    private final ActivityClusterGraph acg;
    private final Map<PartitionId, IPartitionCollector> partitionRequestMap;
    private final IOperatorEnvironment env;
    private final Map<Object, IStateObject> stateObjectMap;
    private final Map<TaskAttemptId, Task> taskMap;
    private final Map<String, Counter> counterMap;
    private final DefaultDeallocatableRegistry deallocatableRegistry;
    private final IWorkspaceFileFactory fileFactory;
    private final Object globalJobData;
    private final IJobletEventListener jobletEventListener;
    private final int frameSize;
    private final AtomicLong memoryAllocation;
    private JobStatus cleanupStatus;
    private boolean cleanupPending;

    public Joblet(NodeControllerService nodeController, DeploymentId deploymentId, JobId jobId, INCApplicationContext appCtx, ActivityClusterGraph acg) {
        this.nodeController = nodeController;
        this.appCtx = appCtx;
        this.deploymentId = deploymentId;
        this.jobId = jobId;
        this.frameSize = acg.getFrameSize();
        this.memoryAllocation = new AtomicLong();
        this.acg = acg;
        this.partitionRequestMap = new HashMap<PartitionId, IPartitionCollector>();
        this.env = new OperatorEnvironmentImpl(nodeController.getId());
        this.stateObjectMap = new HashMap<Object, IStateObject>();
        this.taskMap = new HashMap<TaskAttemptId, Task>();
        this.counterMap = new HashMap<String, Counter>();
        this.deallocatableRegistry = new DefaultDeallocatableRegistry();
        this.fileFactory = new WorkspaceFileFactory((IDeallocatableRegistry)this, (IOManager)appCtx.getRootContext().getIOManager());
        this.cleanupPending = false;
        IJobletEventListenerFactory jelf = acg.getJobletEventListenerFactory();
        if (jelf != null) {
            IJobletEventListener listener;
            this.jobletEventListener = listener = jelf.createListener((IHyracksJobletContext)this);
            listener.jobletStart();
        } else {
            this.jobletEventListener = null;
        }
        IGlobalJobDataFactory gjdf = acg.getGlobalJobDataFactory();
        this.globalJobData = gjdf != null ? gjdf.createGlobalJobData((IHyracksJobletContext)this) : null;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public ActivityClusterGraph getActivityClusterGraph() {
        return this.acg;
    }

    public IOperatorEnvironment getEnvironment() {
        return this.env;
    }

    public void addTask(Task task) {
        this.taskMap.put(task.getTaskAttemptId(), task);
    }

    public void removeTask(Task task) {
        this.taskMap.remove(task.getTaskAttemptId());
        if (this.cleanupPending && this.taskMap.isEmpty()) {
            this.performCleanup();
        }
    }

    public Map<TaskAttemptId, Task> getTaskMap() {
        return this.taskMap;
    }

    public NodeControllerService getNodeController() {
        return this.nodeController;
    }

    public void dumpProfile(JobletProfile jProfile) {
        Map counters = jProfile.getCounters();
        for (Map.Entry<String, Counter> e : this.counterMap.entrySet()) {
            counters.put(e.getKey(), e.getValue().get());
        }
        for (Task task : this.taskMap.values()) {
            TaskProfile taskProfile = new TaskProfile(task.getTaskAttemptId(), new Hashtable<PartitionId, PartitionProfile>(task.getPartitionSendProfile()));
            task.dumpProfile(taskProfile);
            jProfile.getTaskProfiles().put(task.getTaskAttemptId(), taskProfile);
        }
    }

    public INCApplicationContext getApplicationContext() {
        return this.appCtx;
    }

    public ICounterContext getCounterContext() {
        return this;
    }

    public void registerDeallocatable(IDeallocatable deallocatable) {
        this.deallocatableRegistry.registerDeallocatable(deallocatable);
    }

    public void close() {
        long stillAllocated = this.memoryAllocation.get();
        if (stillAllocated > 0L) {
            LOGGER.warning("Freeing leaked " + stillAllocated + " bytes");
            this.appCtx.getMemoryManager().deallocate(stillAllocated);
        }
        this.nodeController.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Joblet.this.deallocatableRegistry.close();
            }
        });
    }

    ByteBuffer allocateFrame() throws HyracksDataException {
        if (this.appCtx.getMemoryManager().allocate((long)this.frameSize)) {
            this.memoryAllocation.addAndGet(this.frameSize);
            return ByteBuffer.allocate(this.frameSize);
        }
        throw new HyracksDataException("Unable to allocate frame: Not enough memory");
    }

    public void deallocateFrames(int nFrames) {
        this.memoryAllocation.addAndGet(nFrames * this.frameSize);
        this.appCtx.getMemoryManager().deallocate((long)(nFrames * this.frameSize));
    }

    final int getFrameSize() {
        return this.frameSize;
    }

    IIOManager getIOManager() {
        return this.appCtx.getRootContext().getIOManager();
    }

    public FileReference createManagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createManagedWorkspaceFile(prefix);
    }

    public FileReference createUnmanagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createUnmanagedWorkspaceFile(prefix);
    }

    public synchronized ICounter getCounter(String name, boolean create) {
        Counter counter = this.counterMap.get(name);
        if (counter == null && create) {
            counter = new Counter(name);
            this.counterMap.put(name, counter);
        }
        return counter;
    }

    public Object getGlobalJobData() {
        return this.globalJobData;
    }

    public synchronized void advertisePartitionRequest(TaskAttemptId taId, Collection<PartitionId> pids, IPartitionCollector collector, PartitionState minState) throws Exception {
        for (PartitionId pid : pids) {
            this.partitionRequestMap.put(pid, collector);
            PartitionRequest req = new PartitionRequest(pid, this.nodeController.getId(), taId, minState);
            this.nodeController.getClusterController().registerPartitionRequest(req);
        }
    }

    public synchronized void reportPartitionAvailability(PartitionChannel channel) throws HyracksException {
        IPartitionCollector collector = this.partitionRequestMap.get(channel.getPartitionId());
        if (collector != null) {
            collector.addPartitions(Collections.singleton(channel));
        }
    }

    public IJobletEventListener getJobletEventListener() {
        return this.jobletEventListener;
    }

    public void cleanup(JobStatus status) {
        this.cleanupStatus = status;
        this.cleanupPending = true;
        if (this.taskMap.isEmpty()) {
            this.performCleanup();
        }
    }

    private void performCleanup() {
        this.nodeController.getJobletMap().remove(this.jobId);
        IJobletEventListener listener = this.getJobletEventListener();
        if (listener != null) {
            listener.jobletFinish(this.cleanupStatus);
        }
        this.close();
        this.cleanupPending = false;
        try {
            this.nodeController.getClusterController().notifyJobletCleanup(this.jobId, this.nodeController.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Class<?> loadClass(String className) {
        try {
            return DeploymentUtils.loadClass((String)className, (DeploymentId)this.deploymentId, (IApplicationContext)this.appCtx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getClassLoader() {
        try {
            return DeploymentUtils.getClassLoader((DeploymentId)this.deploymentId, (IApplicationContext)this.appCtx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final class OperatorEnvironmentImpl
    implements IOperatorEnvironment {
        private final String nodeId;

        public OperatorEnvironmentImpl(String nodeId) {
            this.nodeId = nodeId;
        }

        public String toString() {
            return super.toString() + "@" + this.nodeId;
        }

        public synchronized void setStateObject(IStateObject taskState) {
            Joblet.this.stateObjectMap.put(taskState.getId(), taskState);
        }

        public synchronized IStateObject getStateObject(Object id) {
            return (IStateObject)Joblet.this.stateObjectMap.get(id);
        }
    }
}

