/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.data.std.primitive;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class UTF8StringWriter {
    private byte[] tempBytes;

    public void writeUTF8String(CharSequence str, DataOutput out) throws IOException {
        char c;
        int i;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        if (this.tempBytes == null || this.tempBytes.length < utflen + 2) {
            this.tempBytes = new byte[utflen + 2];
        }
        this.tempBytes[count++] = (byte)(utflen >>> 8 & 0xFF);
        this.tempBytes[count++] = (byte)(utflen >>> 0 & 0xFF);
        i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            this.tempBytes[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.tempBytes[count++] = (byte)c;
            } else if (c > '\u07ff') {
                this.tempBytes[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.tempBytes[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.tempBytes[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                this.tempBytes[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.tempBytes[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        out.write(this.tempBytes, 0, utflen + 2);
    }
}

