/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.data.std.primitive;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.data.std.api.AbstractPointable;
import edu.uci.ics.hyracks.data.std.api.IComparable;
import edu.uci.ics.hyracks.data.std.api.IHashable;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;

public final class UTF8StringPointable
extends AbstractPointable
implements IHashable,
IComparable {
    public static final ITypeTraits TYPE_TRAITS = new ITypeTraits(){
        private static final long serialVersionUID = 1L;

        public boolean isFixedLength() {
            return false;
        }

        public int getFixedLength() {
            return 0;
        }
    };
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        @Override
        public IPointable createPointable() {
            return new UTF8StringPointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }
    };

    public char charAt(int offset) {
        return UTF8StringPointable.charAt(this.bytes, this.start + offset);
    }

    public static char charAt(byte[] b, int s) {
        int c = b[s] & 0xFF;
        switch (c >> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (char)c;
            }
            case 12: 
            case 13: {
                return (char)((c & 0x1F) << 6 | b[s + 1] & 0x3F);
            }
            case 14: {
                return (char)((c & 0xF) << 12 | (b[s + 1] & 0x3F) << 6 | (b[s + 2] & 0x3F) << 0);
            }
        }
        throw new IllegalArgumentException();
    }

    public int charSize(int offset) {
        return UTF8StringPointable.charSize(this.bytes, this.start + offset);
    }

    public static int charSize(byte[] b, int s) {
        int c = b[s] & 0xFF;
        switch (c >> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 1;
            }
            case 12: 
            case 13: {
                return 2;
            }
            case 14: {
                return 3;
            }
        }
        throw new IllegalStateException();
    }

    public static int getModifiedUTF8Len(char c) {
        if (c >= '\u0000' && c <= '\u007f') {
            return 1;
        }
        if (c <= '\u07ff') {
            return 2;
        }
        return 3;
    }

    public int getStringLength() {
        return UTF8StringPointable.getStringLength(this.bytes, this.start);
    }

    public static int getStringLength(byte[] b, int s) {
        int pos;
        int end = pos + UTF8StringPointable.getUTFLength(b, s);
        int charCount = 0;
        for (pos = s + 2; pos < end; pos += UTF8StringPointable.charSize(b, pos)) {
            ++charCount;
        }
        return charCount;
    }

    public int getUTFLength() {
        return UTF8StringPointable.getUTFLength(this.bytes, this.start);
    }

    public static int getUTFLength(byte[] b, int s) {
        return ((b[s] & 0xFF) << 8) + ((b[s + 1] & 0xFF) << 0);
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        int utflen1 = UTF8StringPointable.getUTFLength(this.bytes, this.start);
        int utflen2 = UTF8StringPointable.getUTFLength(bytes, start);
        int c1 = 0;
        int s1Start = this.start + 2;
        int s2Start = start + 2;
        for (int c2 = 0; c1 < utflen1 && c2 < utflen2; c1 += UTF8StringPointable.charSize(this.bytes, s1Start + c1), c2 += UTF8StringPointable.charSize(bytes, s2Start + c2)) {
            char ch2;
            char ch1 = UTF8StringPointable.charAt(this.bytes, s1Start + c1);
            if (ch1 == (ch2 = UTF8StringPointable.charAt(bytes, s2Start + c2))) continue;
            return ch1 - ch2;
        }
        return utflen1 - utflen2;
    }

    @Override
    public int hash() {
        int h = 0;
        int utflen = UTF8StringPointable.getUTFLength(this.bytes, this.start);
        int sStart = this.start + 2;
        for (int c = 0; c < utflen; c += UTF8StringPointable.charSize(this.bytes, sStart + c)) {
            char ch = UTF8StringPointable.charAt(this.bytes, sStart + c);
            h = 31 * h + ch;
        }
        return h;
    }

    public static void toString(StringBuilder buffer, byte[] bytes, int start) {
        int cLen;
        int offset = 2;
        for (int utfLen = UTF8StringPointable.getUTFLength(bytes, start); utfLen > 0; utfLen -= cLen) {
            char c = UTF8StringPointable.charAt(bytes, start + offset);
            buffer.append(c);
            cLen = UTF8StringPointable.getModifiedUTF8Len(c);
            offset += cLen;
        }
    }

    public void toString(StringBuilder buffer) {
        UTF8StringPointable.toString(buffer, this.bytes, this.start);
    }
}

