/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.data.std.primitive;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.data.std.api.AbstractPointable;
import edu.uci.ics.hyracks.data.std.api.IComparable;
import edu.uci.ics.hyracks.data.std.api.IHashable;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;

public final class RawUTF8StringPointable
extends AbstractPointable
implements IHashable,
IComparable {
    public static final ITypeTraits TYPE_TRAITS = new ITypeTraits(){
        private static final long serialVersionUID = 1L;

        public boolean isFixedLength() {
            return false;
        }

        public int getFixedLength() {
            return 0;
        }
    };
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        @Override
        public IPointable createPointable() {
            return new RawUTF8StringPointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }
    };

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        int utflen1 = UTF8StringPointable.getUTFLength(this.bytes, this.start);
        int utflen2 = UTF8StringPointable.getUTFLength(bytes, start);
        int c1 = 0;
        int s1Start = this.start + 2;
        int s2Start = start + 2;
        for (int c2 = 0; c1 < utflen1 && c2 < utflen2; ++c1, ++c2) {
            char ch1 = (char)this.bytes[s1Start + c1];
            char ch2 = (char)bytes[s2Start + c2];
            if (ch1 == ch2) continue;
            return ch1 - ch2;
        }
        return utflen1 - utflen2;
    }

    @Override
    public int hash() {
        int h = 0;
        int utflen = UTF8StringPointable.getUTFLength(this.bytes, this.start);
        int sStart = this.start + 2;
        for (int c = 0; c < utflen; ++c) {
            char ch = (char)this.bytes[sStart + c];
            h = 31 * h + ch;
        }
        return h;
    }

    public void toString(StringBuilder buffer) {
        UTF8StringPointable.toString(buffer, this.bytes, this.start);
    }
}

