/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.data.std.primitive;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.data.std.api.AbstractPointable;
import edu.uci.ics.hyracks.data.std.api.IComparable;
import edu.uci.ics.hyracks.data.std.api.IHashable;
import edu.uci.ics.hyracks.data.std.api.INumeric;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;

public final class LongPointable
extends AbstractPointable
implements IHashable,
IComparable,
INumeric {
    public static final ITypeTraits TYPE_TRAITS = new ITypeTraits(){
        private static final long serialVersionUID = 1L;

        public boolean isFixedLength() {
            return true;
        }

        public int getFixedLength() {
            return 8;
        }
    };
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        @Override
        public IPointable createPointable() {
            return new LongPointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }
    };

    public static long getLong(byte[] bytes, int start) {
        return ((long)(bytes[start] & 0xFF) << 56) + ((long)(bytes[start + 1] & 0xFF) << 48) + ((long)(bytes[start + 2] & 0xFF) << 40) + ((long)(bytes[start + 3] & 0xFF) << 32) + ((long)(bytes[start + 4] & 0xFF) << 24) + ((long)(bytes[start + 5] & 0xFF) << 16) + ((long)(bytes[start + 6] & 0xFF) << 8) + ((long)(bytes[start + 7] & 0xFF) << 0);
    }

    public static void setLong(byte[] bytes, int start, long value) {
        bytes[start] = (byte)(value >>> 56 & 0xFFL);
        bytes[start + 1] = (byte)(value >>> 48 & 0xFFL);
        bytes[start + 2] = (byte)(value >>> 40 & 0xFFL);
        bytes[start + 3] = (byte)(value >>> 32 & 0xFFL);
        bytes[start + 4] = (byte)(value >>> 24 & 0xFFL);
        bytes[start + 5] = (byte)(value >>> 16 & 0xFFL);
        bytes[start + 6] = (byte)(value >>> 8 & 0xFFL);
        bytes[start + 7] = (byte)(value >>> 0 & 0xFFL);
    }

    public long getLong() {
        return LongPointable.getLong(this.bytes, this.start);
    }

    public void setLong(long value) {
        LongPointable.setLong(this.bytes, this.start, value);
    }

    public long preIncrement() {
        long v = this.getLong();
        this.setLong(++v);
        return v;
    }

    public long postIncrement() {
        long v = this.getLong();
        long ov = v++;
        this.setLong(v);
        return ov;
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        long ov;
        long v = this.getLong();
        return v < (ov = LongPointable.getLong(bytes, start)) ? -1 : (v > ov ? 1 : 0);
    }

    @Override
    public int hash() {
        long v = this.getLong();
        return (int)(v ^ v >>> 32);
    }

    @Override
    public byte byteValue() {
        return (byte)this.getLong();
    }

    @Override
    public short shortValue() {
        return (short)this.getLong();
    }

    @Override
    public int intValue() {
        return (int)this.getLong();
    }

    @Override
    public long longValue() {
        return this.getLong();
    }

    @Override
    public float floatValue() {
        return this.getLong();
    }

    @Override
    public double doubleValue() {
        return this.getLong();
    }
}

