/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.data.std.primitive;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.data.std.api.AbstractPointable;
import edu.uci.ics.hyracks.data.std.api.IComparable;
import edu.uci.ics.hyracks.data.std.api.IHashable;
import edu.uci.ics.hyracks.data.std.api.INumeric;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;

public final class IntegerPointable
extends AbstractPointable
implements IHashable,
IComparable,
INumeric {
    public static final ITypeTraits TYPE_TRAITS = new ITypeTraits(){
        private static final long serialVersionUID = 1L;

        public boolean isFixedLength() {
            return true;
        }

        public int getFixedLength() {
            return 4;
        }
    };
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        @Override
        public IPointable createPointable() {
            return new IntegerPointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }
    };

    public static int getInteger(byte[] bytes, int start) {
        return ((bytes[start] & 0xFF) << 24) + ((bytes[start + 1] & 0xFF) << 16) + ((bytes[start + 2] & 0xFF) << 8) + ((bytes[start + 3] & 0xFF) << 0);
    }

    public static void setInteger(byte[] bytes, int start, int value) {
        bytes[start] = (byte)(value >>> 24 & 0xFF);
        bytes[start + 1] = (byte)(value >>> 16 & 0xFF);
        bytes[start + 2] = (byte)(value >>> 8 & 0xFF);
        bytes[start + 3] = (byte)(value >>> 0 & 0xFF);
    }

    public int getInteger() {
        return IntegerPointable.getInteger(this.bytes, this.start);
    }

    public void setInteger(int value) {
        IntegerPointable.setInteger(this.bytes, this.start, value);
    }

    public int preIncrement() {
        int v = this.getInteger();
        this.setInteger(++v);
        return v;
    }

    public int postIncrement() {
        int v = this.getInteger();
        int ov = v++;
        this.setInteger(v);
        return ov;
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        int ov;
        int v = this.getInteger();
        return v < (ov = IntegerPointable.getInteger(bytes, start)) ? -1 : (v > ov ? 1 : 0);
    }

    @Override
    public int hash() {
        return this.getInteger();
    }

    @Override
    public byte byteValue() {
        return (byte)this.getInteger();
    }

    @Override
    public short shortValue() {
        return (short)this.getInteger();
    }

    @Override
    public int intValue() {
        return this.getInteger();
    }

    @Override
    public long longValue() {
        return this.getInteger();
    }

    @Override
    public float floatValue() {
        return this.getInteger();
    }

    @Override
    public double doubleValue() {
        return this.getInteger();
    }
}

