/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.data.std.primitive;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.data.std.api.AbstractPointable;
import edu.uci.ics.hyracks.data.std.api.IComparable;
import edu.uci.ics.hyracks.data.std.api.IHashable;
import edu.uci.ics.hyracks.data.std.api.INumeric;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;

public final class DoublePointable
extends AbstractPointable
implements IHashable,
IComparable,
INumeric {
    private static final double machineEpsilon;
    public static final ITypeTraits TYPE_TRAITS;
    public static final IPointableFactory FACTORY;

    public static long getLongBits(byte[] bytes, int start) {
        return LongPointable.getLong(bytes, start);
    }

    public static double getDouble(byte[] bytes, int start) {
        long bits = DoublePointable.getLongBits(bytes, start);
        return Double.longBitsToDouble(bits);
    }

    public static void setDouble(byte[] bytes, int start, double value) {
        long bits = Double.doubleToLongBits(value);
        LongPointable.setLong(bytes, start, bits);
    }

    public double getDouble() {
        return DoublePointable.getDouble(this.bytes, this.start);
    }

    public void setDouble(double value) {
        DoublePointable.setDouble(this.bytes, this.start, value);
    }

    public double preIncrement() {
        double v = this.getDouble();
        this.setDouble(v += 1.0);
        return v;
    }

    public double postIncrement() {
        double v;
        double d = v = this.getDouble();
        v = d + 1.0;
        double ov = d;
        this.setDouble(v);
        return ov;
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        double ov;
        double v = this.getDouble();
        return v < (ov = DoublePointable.getDouble(bytes, start)) ? -1 : (v > ov ? 1 : 0);
    }

    @Override
    public int hash() {
        long bits = DoublePointable.getLongBits(this.bytes, this.start);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public byte byteValue() {
        return (byte)this.getDouble();
    }

    @Override
    public short shortValue() {
        return (short)this.getDouble();
    }

    @Override
    public int intValue() {
        return (int)this.getDouble();
    }

    @Override
    public long longValue() {
        return (long)this.getDouble();
    }

    @Override
    public float floatValue() {
        return (float)this.getDouble();
    }

    @Override
    public double doubleValue() {
        return this.getDouble();
    }

    public static double getEpsilon() {
        return machineEpsilon;
    }

    static {
        float epsilon = 1.0f;
        while ((double)((float)(1.0 + (double)(epsilon /= 2.0f) / 2.0)) != 1.0) {
        }
        machineEpsilon = epsilon;
        TYPE_TRAITS = new ITypeTraits(){
            private static final long serialVersionUID = 1L;

            public boolean isFixedLength() {
                return true;
            }

            public int getFixedLength() {
                return 8;
            }
        };
        FACTORY = new IPointableFactory(){
            private static final long serialVersionUID = 1L;

            @Override
            public IPointable createPointable() {
                return new DoublePointable();
            }

            @Override
            public ITypeTraits getTypeTraits() {
                return TYPE_TRAITS;
            }
        };
    }
}

