/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.data.std.accessors;

import edu.uci.ics.hyracks.api.dataflow.value.IBinaryHashFunction;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryHashFunctionFamily;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;

public class UTF8StringBinaryHashFunctionFamily
implements IBinaryHashFunctionFamily {
    public static final IBinaryHashFunctionFamily INSTANCE = new UTF8StringBinaryHashFunctionFamily();
    private static final long serialVersionUID = 1L;
    static final int[] primeCoefficents = new int[]{31, 23, 53, 97, 71, 337, 11, 877, 3, 29};

    private UTF8StringBinaryHashFunctionFamily() {
    }

    public IBinaryHashFunction createBinaryHashFunction(int seed) {
        final int coefficient = primeCoefficents[seed % primeCoefficents.length];
        final int r = primeCoefficents[(seed + 1) % primeCoefficents.length];
        return new IBinaryHashFunction(){

            public int hash(byte[] bytes, int offset, int length) {
                int h = 0;
                int utflen = UTF8StringPointable.getUTFLength(bytes, offset);
                int sStart = offset + 2;
                for (int c = 0; c < utflen; c += UTF8StringPointable.charSize(bytes, sStart + c)) {
                    char ch = UTF8StringPointable.charAt(bytes, sStart + c);
                    h = (coefficient * h + ch) % r;
                }
                return h;
            }
        };
    }
}

