/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.api.topology;

import edu.uci.ics.hyracks.api.topology.ClusterTopology;
import edu.uci.ics.hyracks.api.topology.NetworkEndpoint;
import edu.uci.ics.hyracks.api.topology.NetworkSwitch;
import edu.uci.ics.hyracks.api.topology.NetworkTerminal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class TopologyDefinitionParser {
    private final Stack<ElementStackEntry> stack = new Stack();
    private boolean inPropertyElement = false;

    private TopologyDefinitionParser() {
    }

    public static ClusterTopology parse(InputSource in) throws IOException, SAXException {
        TopologyDefinitionParser parser = new TopologyDefinitionParser();
        return parser.parseInternal(in);
    }

    private ClusterTopology parseInternal(InputSource in) throws IOException, SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader();
        SAXContentHandler handler = new SAXContentHandler();
        parser.setContentHandler(handler);
        parser.parse(in);
        if (this.stack.size() != 1) {
            throw new IllegalStateException("Malformed topology definition");
        }
        ElementStackEntry e = this.stack.pop();
        if (e.ports.size() != 1) {
            throw new IllegalArgumentException("Malformed topology definition");
        }
        NetworkEndpoint endpoint = ((NetworkSwitch.Port)e.ports.get(0)).getEndpoint();
        if (endpoint.getType() != NetworkEndpoint.EndpointType.NETWORK_SWITCH) {
            throw new IllegalArgumentException("Top level content in cluster-topology must be network-switch");
        }
        return new ClusterTopology((NetworkSwitch)endpoint);
    }

    private static class ElementStackEntry {
        private final NetworkEndpoint.EndpointType type;
        private final String name;
        private final Map<String, String> properties;
        private final List<NetworkSwitch.Port> ports;

        public ElementStackEntry(NetworkEndpoint.EndpointType type, String name) {
            this.type = type;
            this.name = name;
            this.properties = new HashMap<String, String>();
            this.ports = new ArrayList<NetworkSwitch.Port>();
        }
    }

    private class SAXContentHandler
    extends DefaultHandler {
        private SAXContentHandler() {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("network-switch".equals(localName) || "terminal".equals(localName)) {
                ElementStackEntry e = (ElementStackEntry)TopologyDefinitionParser.this.stack.pop();
                NetworkEndpoint endpoint = e.type == NetworkEndpoint.EndpointType.NETWORK_SWITCH ? new NetworkSwitch(e.name, e.properties, e.ports.toArray(new NetworkSwitch.Port[e.ports.size()])) : new NetworkTerminal(e.name, e.properties);
                ((ElementStackEntry)TopologyDefinitionParser.this.stack.peek()).ports.add(new NetworkSwitch.Port(endpoint));
            } else if ("property".equals(localName)) {
                if (!TopologyDefinitionParser.this.inPropertyElement) {
                    throw new IllegalStateException("Improperly nested property element encountered");
                }
                TopologyDefinitionParser.this.inPropertyElement = false;
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("cluster-topology".equals(localName)) {
                if (!TopologyDefinitionParser.this.stack.isEmpty()) {
                    throw new IllegalStateException("Encountered unexpected " + qName);
                }
                TopologyDefinitionParser.this.stack.push(new ElementStackEntry(null, ""));
            } else if ("network-switch".equals(localName) || "terminal".equals(localName)) {
                String name = atts.getValue("", "name");
                if (name == null) {
                    throw new IllegalStateException("Encountered " + localName + " element with no name attribute");
                }
                NetworkEndpoint.EndpointType type = "network-switch".equals(localName) ? NetworkEndpoint.EndpointType.NETWORK_SWITCH : NetworkEndpoint.EndpointType.NETWORK_TERMINAL;
                ElementStackEntry e = new ElementStackEntry(type, name);
                TopologyDefinitionParser.this.stack.push(e);
            } else if ("property".equals(localName)) {
                if (TopologyDefinitionParser.this.inPropertyElement) {
                    throw new IllegalStateException("Improperly nested property element encountered");
                }
                String name = atts.getValue("", "name");
                if (name == null) {
                    throw new IllegalStateException("Encountered " + localName + " element with no name attribute");
                }
                String value = atts.getValue("", "value");
                if (value == null) {
                    throw new IllegalStateException("Encountered " + localName + " element with no value attribute");
                }
                ((ElementStackEntry)TopologyDefinitionParser.this.stack.peek()).properties.put(name, value);
                TopologyDefinitionParser.this.inPropertyElement = true;
            }
        }
    }
}

