/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.api.rewriter.runtime;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IConnectorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.rewriter.runtime.SuperActivity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class SuperActivityOperatorNodePushable
implements IOperatorNodePushable {
    private final Map<ActivityId, IOperatorNodePushable> operatorNodePushables = new HashMap<ActivityId, IOperatorNodePushable>();
    private final List<IOperatorNodePushable> operatprNodePushablesBFSOrder = new ArrayList<IOperatorNodePushable>();
    private final Map<ActivityId, IActivity> startActivities;
    private final SuperActivity parent;
    private final IHyracksTaskContext ctx;
    private final IRecordDescriptorProvider recordDescProvider;
    private final int partition;
    private final int nPartitions;
    private int inputArity = 0;

    public SuperActivityOperatorNodePushable(SuperActivity parent, Map<ActivityId, IActivity> startActivities, IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        this.parent = parent;
        this.startActivities = startActivities;
        this.ctx = ctx;
        this.recordDescProvider = recordDescProvider;
        this.partition = partition;
        this.nPartitions = nPartitions;
        try {
            this.init();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void initialize() throws HyracksDataException {
        for (IOperatorNodePushable op : this.operatprNodePushablesBFSOrder) {
            op.initialize();
        }
    }

    public void init() throws HyracksDataException {
        HashMap<ActivityId, IOperatorNodePushable> startOperatorNodePushables = new HashMap<ActivityId, IOperatorNodePushable>();
        LinkedList<Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>> childQueue = new LinkedList<Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>>();
        List<IConnectorDescriptor> outputConnectors = null;
        for (Map.Entry<ActivityId, IActivity> entry : this.startActivities.entrySet()) {
            IOperatorNodePushable opPushable = entry.getValue().createPushRuntime(this.ctx, this.recordDescProvider, this.partition, this.nPartitions);
            startOperatorNodePushables.put(entry.getKey(), opPushable);
            this.operatprNodePushablesBFSOrder.add(opPushable);
            this.operatorNodePushables.put(entry.getKey(), opPushable);
            this.inputArity += opPushable.getInputArity();
            outputConnectors = this.parent.getActivityOutputMap().get(entry.getKey());
            if (outputConnectors == null) continue;
            for (IConnectorDescriptor conn : outputConnectors) {
                childQueue.add(this.parent.getConnectorActivityMap().get(conn.getConnectorId()));
            }
        }
        while (childQueue.size() > 0) {
            if (outputConnectors != null && outputConnectors.size() > 0) {
                for (IConnectorDescriptor conn : outputConnectors) {
                    if (conn == null) continue;
                    childQueue.add(this.parent.getConnectorActivityMap().get(conn.getConnectorId()));
                }
            }
            Pair channel = (Pair)childQueue.poll();
            ActivityId sourceId = ((IActivity)((Pair)channel.getLeft()).getLeft()).getActivityId();
            int outputChannel = (Integer)((Pair)channel.getLeft()).getRight();
            ActivityId destId = ((IActivity)((Pair)channel.getRight()).getLeft()).getActivityId();
            int inputChannel = (Integer)((Pair)channel.getRight()).getRight();
            IOperatorNodePushable sourceOp = this.operatorNodePushables.get(sourceId);
            IOperatorNodePushable destOp = this.operatorNodePushables.get(destId);
            if (destOp == null) {
                destOp = ((IActivity)((Pair)channel.getRight()).getLeft()).createPushRuntime(this.ctx, this.recordDescProvider, this.partition, this.nPartitions);
                this.operatprNodePushablesBFSOrder.add(destOp);
                this.operatorNodePushables.put(destId, destOp);
            }
            sourceOp.setOutputFrameWriter(outputChannel, destOp.getInputFrameWriter(inputChannel), this.recordDescProvider.getInputRecordDescriptor(destId, inputChannel));
            outputConnectors = this.parent.getActivityOutputMap().get(destId);
        }
    }

    @Override
    public void deinitialize() throws HyracksDataException {
        for (IOperatorNodePushable op : this.operatprNodePushablesBFSOrder) {
            op.deinitialize();
        }
    }

    @Override
    public int getInputArity() {
        return this.inputArity;
    }

    @Override
    public void setOutputFrameWriter(int clusterOutputIndex, IFrameWriter writer, RecordDescriptor recordDesc) throws HyracksDataException {
        Pair<ActivityId, Integer> activityIdOutputIndex = this.parent.getActivityIdOutputIndex(clusterOutputIndex);
        IOperatorNodePushable opPushable = this.operatorNodePushables.get(activityIdOutputIndex.getLeft());
        opPushable.setOutputFrameWriter((Integer)activityIdOutputIndex.getRight(), writer, recordDesc);
    }

    @Override
    public IFrameWriter getInputFrameWriter(int index) {
        Pair<ActivityId, Integer> activityIdInputIndex = this.parent.getActivityIdInputIndex(index);
        IOperatorNodePushable operatorNodePushable = this.operatorNodePushables.get(activityIdInputIndex.getLeft());
        IFrameWriter writer = operatorNodePushable.getInputFrameWriter((Integer)activityIdInputIndex.getRight());
        return writer;
    }

    @Override
    public String getDisplayName() {
        return "Super Activity " + this.parent.getActivityMap().values().toString();
    }
}

