/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.api.job;

import edu.uci.ics.hyracks.api.constraints.Constraint;
import edu.uci.ics.hyracks.api.dataflow.ConnectorDescriptorId;
import edu.uci.ics.hyracks.api.dataflow.IConnectorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.OperatorDescriptorId;
import edu.uci.ics.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.dataset.ResultSetId;
import edu.uci.ics.hyracks.api.job.IConnectorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.IGlobalJobDataFactory;
import edu.uci.ics.hyracks.api.job.IJobletEventListenerFactory;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JobSpecification
implements Serializable,
IOperatorDescriptorRegistry,
IConnectorDescriptorRegistry {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_FRAME_SIZE = 32768;
    private final List<OperatorDescriptorId> roots = new ArrayList<OperatorDescriptorId>();
    private final List<ResultSetId> resultSetIds = new ArrayList<ResultSetId>();
    private final Map<OperatorDescriptorId, IOperatorDescriptor> opMap = new HashMap<OperatorDescriptorId, IOperatorDescriptor>();
    private final Map<ConnectorDescriptorId, IConnectorDescriptor> connMap = new HashMap<ConnectorDescriptorId, IConnectorDescriptor>();
    private final Map<OperatorDescriptorId, List<IConnectorDescriptor>> opInputMap = new HashMap<OperatorDescriptorId, List<IConnectorDescriptor>>();
    private final Map<OperatorDescriptorId, List<IConnectorDescriptor>> opOutputMap = new HashMap<OperatorDescriptorId, List<IConnectorDescriptor>>();
    private final Map<ConnectorDescriptorId, Pair<Pair<IOperatorDescriptor, Integer>, Pair<IOperatorDescriptor, Integer>>> connectorOpMap = new HashMap<ConnectorDescriptorId, Pair<Pair<IOperatorDescriptor, Integer>, Pair<IOperatorDescriptor, Integer>>>();
    private final Map<String, Serializable> properties = new HashMap<String, Serializable>();
    private final Set<Constraint> userConstraints = new HashSet<Constraint>();
    private IConnectorPolicyAssignmentPolicy connectorPolicyAssignmentPolicy;
    private int frameSize;
    private int maxReattempts = 2;
    private IJobletEventListenerFactory jobletEventListenerFactory;
    private IGlobalJobDataFactory globalJobDataFactory;
    private boolean useConnectorPolicyForScheduling = true;
    private transient int operatorIdCounter = 0;
    private transient int connectorIdCounter = 0;

    public JobSpecification() {
        this(32768);
    }

    public JobSpecification(int frameSize) {
        this.setFrameSize(frameSize);
    }

    @Override
    public OperatorDescriptorId createOperatorDescriptorId(IOperatorDescriptor op) {
        OperatorDescriptorId odId = new OperatorDescriptorId(this.operatorIdCounter++);
        this.opMap.put(odId, op);
        return odId;
    }

    @Override
    public ConnectorDescriptorId createConnectorDescriptor(IConnectorDescriptor conn) {
        ConnectorDescriptorId cdId = new ConnectorDescriptorId(this.connectorIdCounter++);
        this.connMap.put(cdId, conn);
        return cdId;
    }

    public void addRoot(IOperatorDescriptor op) {
        this.roots.add(op.getOperatorId());
    }

    public void addResultSetId(ResultSetId rsId) {
        this.resultSetIds.add(rsId);
    }

    public void connect(IConnectorDescriptor conn, IOperatorDescriptor producerOp, int producerPort, IOperatorDescriptor consumerOp, int consumerPort) {
        this.insertIntoIndexedMap(this.opInputMap, consumerOp.getOperatorId(), consumerPort, conn);
        this.insertIntoIndexedMap(this.opOutputMap, producerOp.getOperatorId(), producerPort, conn);
        this.connectorOpMap.put(conn.getConnectorId(), (Pair<Pair<IOperatorDescriptor, Integer>, Pair<IOperatorDescriptor, Integer>>)Pair.of((Object)Pair.of((Object)producerOp, (Object)producerPort), (Object)Pair.of((Object)consumerOp, (Object)consumerPort)));
    }

    public void setProperty(String name, Serializable value) {
        this.properties.put(name, value);
    }

    public Serializable getProperty(String name) {
        return this.properties.get(name);
    }

    private <T> void extend(List<T> list, int index) {
        int n;
        for (int i = n = list.size(); i <= index; ++i) {
            list.add(null);
        }
    }

    public Map<ConnectorDescriptorId, IConnectorDescriptor> getConnectorMap() {
        return this.connMap;
    }

    public Map<ConnectorDescriptorId, Pair<Pair<IOperatorDescriptor, Integer>, Pair<IOperatorDescriptor, Integer>>> getConnectorOperatorMap() {
        return this.connectorOpMap;
    }

    public RecordDescriptor getConnectorRecordDescriptor(IConnectorDescriptor conn) {
        Pair<Pair<IOperatorDescriptor, Integer>, Pair<IOperatorDescriptor, Integer>> connInfo = this.connectorOpMap.get(conn.getConnectorId());
        return ((IOperatorDescriptor)((Pair)connInfo.getLeft()).getLeft()).getOutputRecordDescriptors()[(Integer)((Pair)connInfo.getLeft()).getRight()];
    }

    public IOperatorDescriptor getConsumer(IConnectorDescriptor conn) {
        Pair<Pair<IOperatorDescriptor, Integer>, Pair<IOperatorDescriptor, Integer>> connInfo = this.connectorOpMap.get(conn.getConnectorId());
        return (IOperatorDescriptor)((Pair)connInfo.getRight()).getLeft();
    }

    public int getConsumerInputIndex(IConnectorDescriptor conn) {
        Pair<Pair<IOperatorDescriptor, Integer>, Pair<IOperatorDescriptor, Integer>> connInfo = this.connectorOpMap.get(conn.getConnectorId());
        return (Integer)((Pair)connInfo.getRight()).getRight();
    }

    public IConnectorDescriptor getInputConnectorDescriptor(IOperatorDescriptor op, int inputIndex) {
        return this.getInputConnectorDescriptor(op.getOperatorId(), inputIndex);
    }

    public IConnectorDescriptor getInputConnectorDescriptor(OperatorDescriptorId odId, int inputIndex) {
        return this.opInputMap.get(odId).get(inputIndex);
    }

    public Map<OperatorDescriptorId, List<IConnectorDescriptor>> getOperatorInputMap() {
        return this.opInputMap;
    }

    public RecordDescriptor getOperatorInputRecordDescriptor(OperatorDescriptorId odId, int inputIndex) {
        return this.getConnectorRecordDescriptor(this.getInputConnectorDescriptor(odId, inputIndex));
    }

    public Map<OperatorDescriptorId, IOperatorDescriptor> getOperatorMap() {
        return this.opMap;
    }

    public Map<OperatorDescriptorId, List<IConnectorDescriptor>> getOperatorOutputMap() {
        return this.opOutputMap;
    }

    public RecordDescriptor getOperatorOutputRecordDescriptor(OperatorDescriptorId odId, int outputIndex) {
        return this.getConnectorRecordDescriptor(this.getOutputConnectorDescriptor(odId, outputIndex));
    }

    public IConnectorDescriptor getOutputConnectorDescriptor(IOperatorDescriptor op, int outputIndex) {
        return this.getOutputConnectorDescriptor(op.getOperatorId(), outputIndex);
    }

    public IConnectorDescriptor getOutputConnectorDescriptor(OperatorDescriptorId odId, int outputIndex) {
        return this.opOutputMap.get(odId).get(outputIndex);
    }

    public IOperatorDescriptor getProducer(IConnectorDescriptor conn) {
        Pair<Pair<IOperatorDescriptor, Integer>, Pair<IOperatorDescriptor, Integer>> connInfo = this.connectorOpMap.get(conn.getConnectorId());
        return (IOperatorDescriptor)((Pair)connInfo.getLeft()).getLeft();
    }

    public int getProducerOutputIndex(IConnectorDescriptor conn) {
        Pair<Pair<IOperatorDescriptor, Integer>, Pair<IOperatorDescriptor, Integer>> connInfo = this.connectorOpMap.get(conn.getConnectorId());
        return (Integer)((Pair)connInfo.getLeft()).getRight();
    }

    public List<OperatorDescriptorId> getRoots() {
        return this.roots;
    }

    public List<ResultSetId> getResultSetIds() {
        return this.resultSetIds;
    }

    public IConnectorPolicyAssignmentPolicy getConnectorPolicyAssignmentPolicy() {
        return this.connectorPolicyAssignmentPolicy;
    }

    public void setConnectorPolicyAssignmentPolicy(IConnectorPolicyAssignmentPolicy connectorPolicyAssignmentPolicy) {
        this.connectorPolicyAssignmentPolicy = connectorPolicyAssignmentPolicy;
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public void setMaxReattempts(int maxReattempts) {
        this.maxReattempts = maxReattempts;
    }

    public int getMaxReattempts() {
        return this.maxReattempts;
    }

    public void addUserConstraint(Constraint constraint) {
        this.userConstraints.add(constraint);
    }

    public Set<Constraint> getUserConstraints() {
        return this.userConstraints;
    }

    public IJobletEventListenerFactory getJobletEventListenerFactory() {
        return this.jobletEventListenerFactory;
    }

    public void setJobletEventListenerFactory(IJobletEventListenerFactory jobletEventListenerFactory) {
        this.jobletEventListenerFactory = jobletEventListenerFactory;
    }

    public IGlobalJobDataFactory getGlobalJobDataFactory() {
        return this.globalJobDataFactory;
    }

    public void setGlobalJobDataFactory(IGlobalJobDataFactory globalJobDataFactory) {
        this.globalJobDataFactory = globalJobDataFactory;
    }

    public boolean isUseConnectorPolicyForScheduling() {
        return this.useConnectorPolicyForScheduling;
    }

    public void setUseConnectorPolicyForScheduling(boolean useConnectorPolicyForScheduling) {
        this.useConnectorPolicyForScheduling = useConnectorPolicyForScheduling;
    }

    private <K, V> void insertIntoIndexedMap(Map<K, List<V>> map, K key, int index, V value) {
        List<V> vList = map.get(key);
        if (vList == null) {
            vList = new ArrayList<V>();
            map.put(key, vList);
        }
        this.extend(vList, index);
        vList.set(index, value);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<OperatorDescriptorId, IOperatorDescriptor> e : this.opMap.entrySet()) {
            List<IConnectorDescriptor> outputs;
            buffer.append(e.getKey().getId()).append(" : ").append(e.getValue().toString()).append("\n");
            List<IConnectorDescriptor> inputs = this.opInputMap.get(e.getKey());
            if (inputs != null && !inputs.isEmpty()) {
                buffer.append("   Inputs:\n");
                for (IConnectorDescriptor c : inputs) {
                    buffer.append("      ").append(c.getConnectorId().getId()).append(" : ").append(c.toString()).append("\n");
                }
            }
            if ((outputs = this.opOutputMap.get(e.getKey())) == null || outputs.isEmpty()) continue;
            buffer.append("   Outputs:\n");
            for (IConnectorDescriptor c : outputs) {
                buffer.append("      ").append(c.getConnectorId().getId()).append(" : ").append(c.toString()).append("\n");
            }
        }
        buffer.append("\n").append("Constraints:\n").append(this.userConstraints);
        return buffer.toString();
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jjob = new JSONObject();
        JSONArray jopArray = new JSONArray();
        for (Map.Entry<OperatorDescriptorId, IOperatorDescriptor> e : this.opMap.entrySet()) {
            jopArray.put((Object)e.getValue().toJSON());
        }
        jjob.put("operators", (Object)jopArray);
        JSONArray jcArray = new JSONArray();
        for (Map.Entry<ConnectorDescriptorId, IConnectorDescriptor> e : this.connMap.entrySet()) {
            JSONObject conn = new JSONObject();
            Pair<Pair<IOperatorDescriptor, Integer>, Pair<IOperatorDescriptor, Integer>> connection = this.connectorOpMap.get(e.getKey());
            if (connection != null) {
                conn.put("in-operator-id", (Object)((IOperatorDescriptor)((Pair)connection.getLeft()).getLeft()).getOperatorId().toString());
                conn.put("in-operator-port", ((Integer)((Pair)connection.getLeft()).getRight()).intValue());
                conn.put("out-operator-id", (Object)((IOperatorDescriptor)((Pair)connection.getRight()).getLeft()).getOperatorId().toString());
                conn.put("out-operator-port", ((Integer)((Pair)connection.getRight()).getRight()).intValue());
            }
            conn.put("connector", (Object)e.getValue().toJSON());
            jcArray.put((Object)conn);
        }
        jjob.put("connectors", (Object)jcArray);
        return jjob;
    }
}

