/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.api.job;

import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.ConnectorDescriptorId;
import edu.uci.ics.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import edu.uci.ics.hyracks.api.job.ActivityCluster;
import edu.uci.ics.hyracks.api.job.ActivityClusterId;
import edu.uci.ics.hyracks.api.job.IGlobalJobDataFactory;
import edu.uci.ics.hyracks.api.job.IJobletEventListenerFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityClusterGraph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int version = 0;
    private final Map<ActivityClusterId, ActivityCluster> activityClusterMap = new HashMap<ActivityClusterId, ActivityCluster>();
    private final Map<ActivityId, ActivityCluster> activityMap = new HashMap<ActivityId, ActivityCluster>();
    private final Map<ConnectorDescriptorId, ActivityCluster> connectorMap = new HashMap<ConnectorDescriptorId, ActivityCluster>();
    private int frameSize = 32768;
    private int maxReattempts;
    private IJobletEventListenerFactory jobletEventListenerFactory;
    private IGlobalJobDataFactory globalJobDataFactory;
    private IConnectorPolicyAssignmentPolicy connectorPolicyAssignmentPolicy;
    private boolean useConnectorPolicyForScheduling;

    public Map<ActivityId, ActivityCluster> getActivityMap() {
        return this.activityMap;
    }

    public Map<ConnectorDescriptorId, ActivityCluster> getConnectorMap() {
        return this.connectorMap;
    }

    public Map<ActivityClusterId, ActivityCluster> getActivityClusterMap() {
        return this.activityClusterMap;
    }

    public void addActivityClusters(Collection<ActivityCluster> newActivityClusters) {
        for (ActivityCluster ac : newActivityClusters) {
            this.activityClusterMap.put(ac.getId(), ac);
            for (ActivityId aid : ac.getActivityMap().keySet()) {
                this.activityMap.put(aid, ac);
            }
            for (ConnectorDescriptorId cid : ac.getConnectorMap().keySet()) {
                this.connectorMap.put(cid, ac);
            }
        }
        ++this.version;
    }

    public int getVersion() {
        return this.version;
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public void setMaxReattempts(int maxReattempts) {
        this.maxReattempts = maxReattempts;
    }

    public int getMaxReattempts() {
        return this.maxReattempts;
    }

    public IJobletEventListenerFactory getJobletEventListenerFactory() {
        return this.jobletEventListenerFactory;
    }

    public void setJobletEventListenerFactory(IJobletEventListenerFactory jobletEventListenerFactory) {
        this.jobletEventListenerFactory = jobletEventListenerFactory;
    }

    public IGlobalJobDataFactory getGlobalJobDataFactory() {
        return this.globalJobDataFactory;
    }

    public void setGlobalJobDataFactory(IGlobalJobDataFactory globalJobDataFactory) {
        this.globalJobDataFactory = globalJobDataFactory;
    }

    public IConnectorPolicyAssignmentPolicy getConnectorPolicyAssignmentPolicy() {
        return this.connectorPolicyAssignmentPolicy;
    }

    public void setConnectorPolicyAssignmentPolicy(IConnectorPolicyAssignmentPolicy connectorPolicyAssignmentPolicy) {
        this.connectorPolicyAssignmentPolicy = connectorPolicyAssignmentPolicy;
    }

    public boolean isUseConnectorPolicyForScheduling() {
        return this.useConnectorPolicyForScheduling;
    }

    public void setUseConnectorPolicyForScheduling(boolean useConnectorPolicyForScheduling) {
        this.useConnectorPolicyForScheduling = useConnectorPolicyForScheduling;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject acgj = new JSONObject();
        JSONArray acl = new JSONArray();
        for (ActivityCluster ac : this.activityClusterMap.values()) {
            acl.put((Object)ac.toJSON());
        }
        acgj.put("version", this.version);
        acgj.put("activity-clusters", (Object)acl);
        return acgj;
    }
}

