/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.api.job;

import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.ConnectorDescriptorId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IConnectorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.job.ActivityClusterGraph;
import edu.uci.ics.hyracks.api.job.ActivityClusterId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityCluster
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ActivityClusterGraph acg;
    private final ActivityClusterId id;
    private final List<IActivity> roots;
    private final Map<ActivityId, IActivity> activities;
    private final Map<ConnectorDescriptorId, IConnectorDescriptor> connectors;
    private final Map<ConnectorDescriptorId, RecordDescriptor> connectorRecordDescriptorMap;
    private final Map<ActivityId, List<IConnectorDescriptor>> activityInputMap;
    private final Map<ActivityId, List<IConnectorDescriptor>> activityOutputMap;
    private final Map<ConnectorDescriptorId, Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>> connectorActivityMap;
    private final Map<ActivityId, Set<ActivityId>> blocked2blockerMap;
    private final List<ActivityCluster> dependencies;
    private IConnectorPolicyAssignmentPolicy cpap;

    public ActivityCluster(ActivityClusterGraph acg, ActivityClusterId id) {
        this.acg = acg;
        this.id = id;
        this.roots = new ArrayList<IActivity>();
        this.activities = new HashMap<ActivityId, IActivity>();
        this.connectors = new HashMap<ConnectorDescriptorId, IConnectorDescriptor>();
        this.connectorRecordDescriptorMap = new HashMap<ConnectorDescriptorId, RecordDescriptor>();
        this.activityInputMap = new HashMap<ActivityId, List<IConnectorDescriptor>>();
        this.activityOutputMap = new HashMap<ActivityId, List<IConnectorDescriptor>>();
        this.connectorActivityMap = new HashMap<ConnectorDescriptorId, Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>>();
        this.blocked2blockerMap = new HashMap<ActivityId, Set<ActivityId>>();
        this.dependencies = new ArrayList<ActivityCluster>();
    }

    public ActivityClusterGraph getActivityClusterGraph() {
        return this.acg;
    }

    public ActivityClusterId getId() {
        return this.id;
    }

    public void addRoot(IActivity activity) {
        this.roots.add(activity);
    }

    public void addActivity(IActivity activity) {
        this.activities.put(activity.getActivityId(), activity);
    }

    public void addConnector(IConnectorDescriptor connector) {
        this.connectors.put(connector.getConnectorId(), connector);
    }

    public void connect(IConnectorDescriptor connector, IActivity producerActivity, int producerPort, IActivity consumerActivity, int consumerPort, RecordDescriptor recordDescriptor) {
        if (!this.activities.containsKey(producerActivity.getActivityId()) || !this.activities.containsKey(consumerActivity.getActivityId())) {
            throw new IllegalStateException("Connected Activities belong to different Activity Clusters: " + producerActivity.getActivityId() + " and " + consumerActivity.getActivityId());
        }
        this.insertIntoIndexedMap(this.activityInputMap, consumerActivity.getActivityId(), consumerPort, connector);
        this.insertIntoIndexedMap(this.activityOutputMap, producerActivity.getActivityId(), producerPort, connector);
        this.connectorActivityMap.put(connector.getConnectorId(), (Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>)Pair.of((Object)Pair.of((Object)producerActivity, (Object)producerPort), (Object)Pair.of((Object)consumerActivity, (Object)consumerPort)));
        this.connectorRecordDescriptorMap.put(connector.getConnectorId(), recordDescriptor);
    }

    public List<IActivity> getRoots() {
        return this.roots;
    }

    public Map<ActivityId, IActivity> getActivityMap() {
        return this.activities;
    }

    public Map<ConnectorDescriptorId, IConnectorDescriptor> getConnectorMap() {
        return this.connectors;
    }

    public Map<ConnectorDescriptorId, RecordDescriptor> getConnectorRecordDescriptorMap() {
        return this.connectorRecordDescriptorMap;
    }

    public Map<ConnectorDescriptorId, Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>> getConnectorActivityMap() {
        return this.connectorActivityMap;
    }

    public Map<ActivityId, List<IConnectorDescriptor>> getActivityInputMap() {
        return this.activityInputMap;
    }

    public Map<ActivityId, List<IConnectorDescriptor>> getActivityOutputMap() {
        return this.activityOutputMap;
    }

    public ActivityId getConsumerActivity(ConnectorDescriptorId cdId) {
        Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>> connEdge = this.connectorActivityMap.get(cdId);
        return ((IActivity)((Pair)connEdge.getRight()).getLeft()).getActivityId();
    }

    public ActivityId getProducerActivity(ConnectorDescriptorId cdId) {
        Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>> connEdge = this.connectorActivityMap.get(cdId);
        return ((IActivity)((Pair)connEdge.getLeft()).getLeft()).getActivityId();
    }

    public Map<ActivityId, Set<ActivityId>> getBlocked2BlockerMap() {
        return this.blocked2blockerMap;
    }

    public List<ActivityCluster> getDependencies() {
        return this.dependencies;
    }

    public IConnectorPolicyAssignmentPolicy getConnectorPolicyAssignmentPolicy() {
        return this.cpap;
    }

    public void setConnectorPolicyAssignmentPolicy(IConnectorPolicyAssignmentPolicy cpap) {
        this.cpap = cpap;
    }

    private <T> void extend(List<T> list, int index) {
        int n;
        for (int i = n = list.size(); i <= index; ++i) {
            list.add(null);
        }
    }

    private <K, V> void insertIntoIndexedMap(Map<K, List<V>> map, K key, int index, V value) {
        List<V> vList = map.get(key);
        if (vList == null) {
            vList = new ArrayList<V>();
            map.put(key, vList);
        }
        this.extend(vList, index);
        vList.set(index, value);
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jac = new JSONObject();
        JSONArray jans = new JSONArray();
        for (IActivity an : this.activities.values()) {
            Set<ActivityId> blockers;
            List<IConnectorDescriptor> outputs;
            JSONObject jan = new JSONObject();
            jan.put("id", (Object)an.getActivityId().toString());
            jan.put("java-class", (Object)an.getClass().getName());
            List<IConnectorDescriptor> inputs = this.activityInputMap.get(an.getActivityId());
            if (inputs != null) {
                JSONArray jInputs = new JSONArray();
                for (int i = 0; i < inputs.size(); ++i) {
                    JSONObject jInput = new JSONObject();
                    jInput.put("input-port", i);
                    jInput.put("connector-id", (Object)inputs.get(i).getConnectorId().toString());
                    jInputs.put((Object)jInput);
                }
                jan.put("inputs", (Object)jInputs);
            }
            if ((outputs = this.activityOutputMap.get(an.getActivityId())) != null) {
                JSONArray jOutputs = new JSONArray();
                for (int i = 0; i < outputs.size(); ++i) {
                    JSONObject jOutput = new JSONObject();
                    jOutput.put("output-port", i);
                    jOutput.put("connector-id", (Object)outputs.get(i).getConnectorId().toString());
                    jOutputs.put((Object)jOutput);
                }
                jan.put("outputs", (Object)jOutputs);
            }
            if ((blockers = this.getBlocked2BlockerMap().get(an.getActivityId())) != null) {
                JSONArray jDeps = new JSONArray();
                for (ActivityId blocker : blockers) {
                    jDeps.put((Object)blocker.toString());
                }
                jan.put("depends-on", (Object)jDeps);
            }
            jans.put((Object)jan);
        }
        jac.put("activities", (Object)jans);
        return jac;
    }
}

