/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.api.dataflow;

import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import java.io.Serializable;

public final class TaskId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ActivityId activityId;
    private final int partition;

    public TaskId(ActivityId activityId, int partition) {
        this.activityId = activityId;
        this.partition = partition;
    }

    public ActivityId getActivityId() {
        return this.activityId;
    }

    public int getPartition() {
        return this.partition;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TaskId)) {
            return false;
        }
        TaskId oTaskId = (TaskId)o;
        return oTaskId.partition == this.partition && oTaskId.activityId.equals(this.activityId);
    }

    public int hashCode() {
        return this.activityId.hashCode() + this.partition;
    }

    public String toString() {
        return "TID:" + this.activityId + ":" + this.partition;
    }

    public static TaskId parse(String str) {
        if (str.startsWith("TID:")) {
            str = str.substring(4);
            int idIdx = str.lastIndexOf(58);
            return new TaskId(ActivityId.parse(str.substring(0, idIdx)), Integer.parseInt(str.substring(idIdx + 1)));
        }
        throw new IllegalArgumentException("Unable to parse: " + str);
    }
}

