/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.api.dataflow;

import edu.uci.ics.hyracks.api.dataflow.TaskId;
import java.io.Serializable;

public final class TaskAttemptId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TaskId taskId;
    private final int attempt;

    public TaskAttemptId(TaskId taskId, int attempt) {
        this.taskId = taskId;
        this.attempt = attempt;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TaskAttemptId)) {
            return false;
        }
        TaskAttemptId oTaskId = (TaskAttemptId)o;
        return oTaskId.attempt == this.attempt && oTaskId.taskId.equals(this.taskId);
    }

    public int hashCode() {
        return this.taskId.hashCode() + this.attempt;
    }

    public String toString() {
        return "TAID:" + this.taskId + ":" + this.attempt;
    }

    public static TaskAttemptId parse(String str) {
        if (str.startsWith("TAID:")) {
            str = str.substring(5);
            int idIdx = str.lastIndexOf(58);
            return new TaskAttemptId(TaskId.parse(str.substring(0, idIdx)), Integer.parseInt(str.substring(idIdx + 1)));
        }
        throw new IllegalArgumentException("Unable to parse: " + str);
    }
}

