/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.api.client.impl;

import edu.uci.ics.hyracks.api.application.ICCApplicationContext;
import edu.uci.ics.hyracks.api.client.impl.ActivityClusterGraphBuilder;
import edu.uci.ics.hyracks.api.client.impl.IConnectorDescriptorVisitor;
import edu.uci.ics.hyracks.api.client.impl.IOperatorDescriptorVisitor;
import edu.uci.ics.hyracks.api.client.impl.JobActivityGraphBuilder;
import edu.uci.ics.hyracks.api.client.impl.PlanUtils;
import edu.uci.ics.hyracks.api.constraints.Constraint;
import edu.uci.ics.hyracks.api.constraints.IConstraintAcceptor;
import edu.uci.ics.hyracks.api.dataflow.IConnectorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.job.ActivityClusterGraph;
import edu.uci.ics.hyracks.api.job.IActivityClusterGraphGenerator;
import edu.uci.ics.hyracks.api.job.IActivityClusterGraphGeneratorFactory;
import edu.uci.ics.hyracks.api.job.JobActivityGraph;
import edu.uci.ics.hyracks.api.job.JobFlag;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.job.JobSpecification;
import edu.uci.ics.hyracks.api.rewriter.ActivityClusterGraphRewriter;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class JobSpecificationActivityClusterGraphGeneratorFactory
implements IActivityClusterGraphGeneratorFactory {
    private static final long serialVersionUID = 1L;
    private final JobSpecification spec;

    public JobSpecificationActivityClusterGraphGeneratorFactory(JobSpecification jobSpec) {
        this.spec = jobSpec;
    }

    @Override
    public JobSpecification getJobSpecification() {
        return this.spec;
    }

    @Override
    public IActivityClusterGraphGenerator createActivityClusterGraphGenerator(JobId jobId, final ICCApplicationContext ccAppCtx, EnumSet<JobFlag> jobFlags) throws HyracksException {
        final JobActivityGraphBuilder builder = new JobActivityGraphBuilder(this.spec, jobFlags);
        PlanUtils.visit(this.spec, new IConnectorDescriptorVisitor(){

            @Override
            public void visit(IConnectorDescriptor conn) throws HyracksException {
                builder.addConnector(conn);
            }
        });
        PlanUtils.visit(this.spec, new IOperatorDescriptorVisitor(){

            @Override
            public void visit(IOperatorDescriptor op) {
                op.contributeActivities(builder);
            }
        });
        builder.finish();
        JobActivityGraph jag = builder.getActivityGraph();
        ActivityClusterGraphBuilder acgb = new ActivityClusterGraphBuilder();
        final ActivityClusterGraph acg = acgb.inferActivityClusters(jobId, jag);
        acg.setFrameSize(this.spec.getFrameSize());
        acg.setMaxReattempts(this.spec.getMaxReattempts());
        acg.setJobletEventListenerFactory(this.spec.getJobletEventListenerFactory());
        acg.setGlobalJobDataFactory(this.spec.getGlobalJobDataFactory());
        acg.setConnectorPolicyAssignmentPolicy(this.spec.getConnectorPolicyAssignmentPolicy());
        acg.setUseConnectorPolicyForScheduling(this.spec.isUseConnectorPolicyForScheduling());
        final HashSet<Constraint> constraints = new HashSet<Constraint>();
        final IConstraintAcceptor acceptor = new IConstraintAcceptor(){

            @Override
            public void addConstraint(Constraint constraint) {
                constraints.add(constraint);
            }
        };
        PlanUtils.visit(this.spec, new IOperatorDescriptorVisitor(){

            @Override
            public void visit(IOperatorDescriptor op) {
                op.contributeSchedulingConstraints(acceptor, ccAppCtx);
            }
        });
        PlanUtils.visit(this.spec, new IConnectorDescriptorVisitor(){

            @Override
            public void visit(IConnectorDescriptor conn) {
                conn.contributeSchedulingConstraints(acceptor, acg.getConnectorMap().get(conn.getConnectorId()), ccAppCtx);
            }
        });
        constraints.addAll(this.spec.getUserConstraints());
        return new IActivityClusterGraphGenerator(){

            @Override
            public ActivityClusterGraph initialize() {
                ActivityClusterGraphRewriter rewriter = new ActivityClusterGraphRewriter();
                rewriter.rewrite(acg);
                return acg;
            }

            @Override
            public Set<Constraint> getConstraints() {
                return constraints;
            }
        };
    }
}

