/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.api.client;

import edu.uci.ics.hyracks.api.client.ClusterControllerInfo;
import edu.uci.ics.hyracks.api.client.HyracksClientInterfaceRemoteProxy;
import edu.uci.ics.hyracks.api.client.IHyracksClientConnection;
import edu.uci.ics.hyracks.api.client.IHyracksClientInterface;
import edu.uci.ics.hyracks.api.client.NodeControllerInfo;
import edu.uci.ics.hyracks.api.client.impl.JobSpecificationActivityClusterGraphGeneratorFactory;
import edu.uci.ics.hyracks.api.comm.NetworkAddress;
import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.job.IActivityClusterGraphGeneratorFactory;
import edu.uci.ics.hyracks.api.job.JobFlag;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.job.JobInfo;
import edu.uci.ics.hyracks.api.job.JobSpecification;
import edu.uci.ics.hyracks.api.job.JobStatus;
import edu.uci.ics.hyracks.api.topology.ClusterTopology;
import edu.uci.ics.hyracks.api.util.JavaSerializationUtils;
import edu.uci.ics.hyracks.ipc.api.IIPCHandle;
import edu.uci.ics.hyracks.ipc.api.IIPCI;
import edu.uci.ics.hyracks.ipc.api.IPayloadSerializerDeserializer;
import edu.uci.ics.hyracks.ipc.api.RPCInterface;
import edu.uci.ics.hyracks.ipc.impl.IPCSystem;
import edu.uci.ics.hyracks.ipc.impl.JavaSerializationBasedPayloadSerializerDeserializer;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.DefaultHttpClient;

public final class HyracksConnection
implements IHyracksClientConnection {
    private final String ccHost;
    private final IPCSystem ipc;
    private final IHyracksClientInterface hci;
    private final ClusterControllerInfo ccInfo;

    public HyracksConnection(String ccHost, int ccPort) throws Exception {
        this.ccHost = ccHost;
        RPCInterface rpci = new RPCInterface();
        this.ipc = new IPCSystem(new InetSocketAddress(0), (IIPCI)rpci, (IPayloadSerializerDeserializer)new JavaSerializationBasedPayloadSerializerDeserializer());
        this.ipc.start();
        IIPCHandle ccIpchandle = this.ipc.getHandle(new InetSocketAddress(ccHost, ccPort));
        this.hci = new HyracksClientInterfaceRemoteProxy(ccIpchandle, rpci);
        this.ccInfo = this.hci.getClusterControllerInfo();
    }

    @Override
    public JobStatus getJobStatus(JobId jobId) throws Exception {
        return this.hci.getJobStatus(jobId);
    }

    @Override
    public JobId startJob(JobSpecification jobSpec) throws Exception {
        return this.startJob(jobSpec, EnumSet.noneOf(JobFlag.class));
    }

    @Override
    public JobId startJob(JobSpecification jobSpec, EnumSet<JobFlag> jobFlags) throws Exception {
        JobSpecificationActivityClusterGraphGeneratorFactory jsacggf = new JobSpecificationActivityClusterGraphGeneratorFactory(jobSpec);
        return this.startJob(jsacggf, jobFlags);
    }

    @Override
    public JobId startJob(IActivityClusterGraphGeneratorFactory acggf, EnumSet<JobFlag> jobFlags) throws Exception {
        return this.hci.startJob(JavaSerializationUtils.serialize(acggf), jobFlags);
    }

    @Override
    public NetworkAddress getDatasetDirectoryServiceInfo() throws Exception {
        return this.hci.getDatasetDirectoryServiceInfo();
    }

    @Override
    public void waitForCompletion(JobId jobId) throws Exception {
        this.hci.waitForCompletion(jobId);
    }

    @Override
    public Map<String, NodeControllerInfo> getNodeControllerInfos() throws Exception {
        return this.hci.getNodeControllersInfo();
    }

    @Override
    public ClusterTopology getClusterTopology() throws Exception {
        return this.hci.getClusterTopology();
    }

    @Override
    public DeploymentId deployBinary(List<String> jars) throws Exception {
        DeploymentId deploymentId = new DeploymentId(UUID.randomUUID().toString());
        ArrayList<URL> binaryURLs = new ArrayList<URL>();
        if (jars != null && jars.size() > 0) {
            DefaultHttpClient hc = new DefaultHttpClient();
            for (String jar : jars) {
                int slashIndex = jar.lastIndexOf(47);
                String fileName = jar.substring(slashIndex + 1);
                String url = "http://" + this.ccHost + ":" + this.ccInfo.getWebPort() + "/applications/" + deploymentId.toString() + "&" + fileName;
                HttpPut put = new HttpPut(url);
                put.setEntity((HttpEntity)new FileEntity(new File(jar), "application/octet-stream"));
                HttpResponse response = hc.execute((HttpUriRequest)put);
                if (response != null) {
                    response.getEntity().consumeContent();
                }
                if (response.getStatusLine().getStatusCode() != 200) {
                    this.hci.unDeployBinary(deploymentId);
                    throw new HyracksException(response.getStatusLine().toString());
                }
                binaryURLs.add(new URL(url));
            }
        }
        this.hci.deployBinary(binaryURLs, deploymentId);
        return deploymentId;
    }

    @Override
    public void unDeployBinary(DeploymentId deploymentId) throws Exception {
        this.hci.unDeployBinary(deploymentId);
    }

    @Override
    public JobId startJob(DeploymentId deploymentId, JobSpecification jobSpec) throws Exception {
        return this.startJob(deploymentId, jobSpec, EnumSet.noneOf(JobFlag.class));
    }

    @Override
    public JobId startJob(DeploymentId deploymentId, JobSpecification jobSpec, EnumSet<JobFlag> jobFlags) throws Exception {
        JobSpecificationActivityClusterGraphGeneratorFactory jsacggf = new JobSpecificationActivityClusterGraphGeneratorFactory(jobSpec);
        return this.startJob(deploymentId, jsacggf, jobFlags);
    }

    @Override
    public JobId startJob(DeploymentId deploymentId, IActivityClusterGraphGeneratorFactory acggf, EnumSet<JobFlag> jobFlags) throws Exception {
        return this.hci.startJob(deploymentId, JavaSerializationUtils.serialize(acggf), jobFlags);
    }

    @Override
    public JobInfo getJobInfo(JobId jobId) throws Exception {
        return this.hci.getJobInfo(jobId);
    }
}

