/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.std;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.base.IUnnestingEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IUnnestingEvaluatorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.evaluators.ConstantEvaluatorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class UnnestRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final int outCol;
    private final IUnnestingEvaluatorFactory unnestingFactory;
    private int outColPos;
    private final boolean outColIsProjected;
    private final boolean hasPositionalVariable;
    private IScalarEvaluatorFactory posOffsetEvalFactory;

    public UnnestRuntimeFactory(int outCol, IUnnestingEvaluatorFactory unnestingFactory, int[] projectionList) {
        this(outCol, unnestingFactory, projectionList, false, null);
    }

    public UnnestRuntimeFactory(int outCol, IUnnestingEvaluatorFactory unnestingFactory, int[] projectionList, boolean hashPositionalVariable, IScalarEvaluatorFactory posOffsetEvalFactory) {
        super(projectionList);
        this.outCol = outCol;
        this.unnestingFactory = unnestingFactory;
        this.outColPos = -1;
        for (int f = 0; f < projectionList.length; ++f) {
            if (projectionList[f] != outCol) continue;
            this.outColPos = f;
        }
        this.outColIsProjected = this.outColPos >= 0;
        this.hasPositionalVariable = hashPositionalVariable;
        this.posOffsetEvalFactory = posOffsetEvalFactory;
        if (this.posOffsetEvalFactory == null) {
            this.posOffsetEvalFactory = new ConstantEvaluatorFactory(new byte[5]);
        }
    }

    public String toString() {
        return "unnest " + this.outCol + " <- " + this.unnestingFactory;
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws AlgebricksException {
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private IPointable p = VoidPointable.FACTORY.createPointable();
            private IUnnestingEvaluator agg;
            private ArrayTupleBuilder tupleBuilder;
            private IScalarEvaluator offsetEval = UnnestRuntimeFactory.access$000(UnnestRuntimeFactory.this).createScalarEvaluator(ctx);

            public void open() throws HyracksDataException {
                this.initAccessAppendRef(ctx);
                try {
                    this.agg = UnnestRuntimeFactory.this.unnestingFactory.createUnnestingEvaluator(ctx);
                }
                catch (AlgebricksException ae) {
                    throw new HyracksDataException((Throwable)ae);
                }
                this.tupleBuilder = new ArrayTupleBuilder(UnnestRuntimeFactory.this.projectionList.length);
                this.writer.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                for (int t = 0; t < nTuple; ++t) {
                    this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                    try {
                        this.offsetEval.evaluate((IFrameTupleReference)this.tRef, this.p);
                    }
                    catch (AlgebricksException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                    int offset = IntegerSerializerDeserializer.getInt((byte[])this.p.getByteArray(), (int)this.p.getStartOffset());
                    try {
                        this.agg.init((IFrameTupleReference)this.tRef);
                        int positionIndex = 1;
                        boolean goon = true;
                        do {
                            this.tupleBuilder.reset();
                            if (!this.agg.step(this.p)) {
                                goon = false;
                                continue;
                            }
                            if (!UnnestRuntimeFactory.this.outColIsProjected && !UnnestRuntimeFactory.this.hasPositionalVariable) {
                                this.appendProjectionToFrame(t, UnnestRuntimeFactory.this.projectionList);
                            } else {
                                int f;
                                for (f = 0; f < UnnestRuntimeFactory.this.outColPos; ++f) {
                                    this.tupleBuilder.addField((IFrameTupleAccessor)this.tAccess, t, f);
                                }
                                if (UnnestRuntimeFactory.this.outColIsProjected) {
                                    this.tupleBuilder.addField(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength());
                                } else {
                                    this.tupleBuilder.addField((IFrameTupleAccessor)this.tAccess, t, UnnestRuntimeFactory.this.outColPos);
                                }
                                for (f = UnnestRuntimeFactory.this.outColPos + 1; f < (UnnestRuntimeFactory.this.hasPositionalVariable ? UnnestRuntimeFactory.this.projectionList.length - 1 : UnnestRuntimeFactory.this.projectionList.length); ++f) {
                                    this.tupleBuilder.addField((IFrameTupleAccessor)this.tAccess, t, f);
                                }
                            }
                            if (UnnestRuntimeFactory.this.hasPositionalVariable) {
                                this.tupleBuilder.getDataOutput().writeByte(3);
                                this.tupleBuilder.getDataOutput().writeInt(offset + positionIndex++);
                                this.tupleBuilder.addFieldEndOffset();
                            }
                            this.appendToFrameFromTupleBuilder(this.tupleBuilder);
                        } while (goon);
                        continue;
                    }
                    catch (AlgebricksException | IOException ae) {
                        throw new HyracksDataException(ae);
                    }
                }
            }
        };
    }

    static /* synthetic */ IScalarEvaluatorFactory access$000(UnnestRuntimeFactory x0) {
        return x0.posOffsetEvalFactory;
    }
}

