/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.std;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.data.IPrinter;
import edu.uci.ics.hyracks.algebricks.data.IPrinterFactory;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.std.file.ITupleParser;
import edu.uci.ics.hyracks.dataflow.std.file.ITupleParserFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public class StringStreamingRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private String command;
    private IPrinterFactory[] printerFactories;
    private char fieldDelimiter;
    private ITupleParserFactory parserFactory;

    public StringStreamingRuntimeFactory(String command, IPrinterFactory[] printerFactories, char fieldDelimiter, ITupleParserFactory parserFactory) {
        super(null);
        this.command = command;
        this.printerFactories = printerFactories;
        this.fieldDelimiter = fieldDelimiter;
        this.parserFactory = parserFactory;
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws AlgebricksException {
        final IPrinter[] printers = new IPrinter[this.printerFactories.length];
        for (int i = 0; i < this.printerFactories.length; ++i) {
            printers[i] = this.printerFactories[i].createPrinter();
        }
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private Process process;
            private PrintStream ps;
            private boolean first = true;
            private Thread outputPipe;
            private Thread dumpStderr;

            public void open() throws HyracksDataException {
                if (this.first) {
                    this.first = false;
                    this.initAccessAppendRef(ctx);
                }
                try {
                    ITupleParser parser = StringStreamingRuntimeFactory.this.parserFactory.createTupleParser(ctx);
                    this.process = Runtime.getRuntime().exec(StringStreamingRuntimeFactory.this.command);
                    this.ps = new PrintStream(this.process.getOutputStream());
                    ForwardScriptOutput fso = new ForwardScriptOutput(parser, this.process.getInputStream());
                    this.outputPipe = new Thread(fso);
                    this.outputPipe.start();
                    DumpInStreamToPrintStream disps = new DumpInStreamToPrintStream(this.process.getErrorStream(), System.err);
                    this.dumpStderr = new Thread(disps);
                    this.dumpStderr.start();
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                for (int t = 0; t < nTuple; ++t) {
                    this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                    for (int i = 0; i < printers.length; ++i) {
                        try {
                            printers[i].print(buffer.array(), this.tRef.getFieldStart(i), this.tRef.getFieldLength(i), this.ps);
                        }
                        catch (AlgebricksException e) {
                            throw new HyracksDataException((Throwable)e);
                        }
                        this.ps.print(StringStreamingRuntimeFactory.this.fieldDelimiter);
                        if (i != printers.length - 1) continue;
                        this.ps.print('\n');
                    }
                }
            }

            @Override
            public void close() throws HyracksDataException {
                this.ps.close();
                int ret = 0;
                try {
                    ret = this.process.waitFor();
                    this.outputPipe.join();
                    this.dumpStderr.join();
                }
                catch (InterruptedException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                if (ret != 0) {
                    throw new HyracksDataException("Process exit value: " + ret);
                }
                super.close();
            }

            final class DumpInStreamToPrintStream
            implements Runnable {
                private BufferedReader reader;
                private PrintStream printStream;

                public DumpInStreamToPrintStream(InputStream inStream, PrintStream printStream) {
                    this.reader = new BufferedReader(new InputStreamReader(inStream));
                    this.printStream = printStream;
                }

                @Override
                public void run() {
                    try {
                        String s;
                        while ((s = this.reader.readLine()) != null) {
                            this.printStream.println(s);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        try {
                            this.reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        this.printStream.close();
                    }
                }
            }

            final class ForwardScriptOutput
            implements Runnable {
                private InputStream inStream;
                private ITupleParser parser;

                public ForwardScriptOutput(ITupleParser parser, InputStream inStream) {
                    this.parser = parser;
                    this.inStream = inStream;
                }

                @Override
                public void run() {
                    try {
                        this.parser.parse(this.inStream, writer);
                    }
                    catch (HyracksDataException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        try {
                            this.inStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        };
    }
}

