/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.std;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.data.IBinaryBooleanInspector;
import edu.uci.ics.hyracks.algebricks.data.IBinaryBooleanInspectorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import java.nio.ByteBuffer;

public class StreamSelectRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private IScalarEvaluatorFactory cond;
    private IBinaryBooleanInspectorFactory binaryBooleanInspectorFactory;

    public StreamSelectRuntimeFactory(IScalarEvaluatorFactory cond, int[] projectionList, IBinaryBooleanInspectorFactory binaryBooleanInspectorFactory) {
        super(projectionList);
        this.cond = cond;
        this.binaryBooleanInspectorFactory = binaryBooleanInspectorFactory;
    }

    public String toString() {
        return "stream-select " + this.cond.toString();
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) {
        final IBinaryBooleanInspector bbi = this.binaryBooleanInspectorFactory.createBinaryBooleanInspector(ctx);
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private IPointable p = VoidPointable.FACTORY.createPointable();
            private IScalarEvaluator eval;

            public void open() throws HyracksDataException {
                if (this.eval == null) {
                    this.initAccessAppendRef(ctx);
                    try {
                        this.eval = StreamSelectRuntimeFactory.this.cond.createScalarEvaluator(ctx);
                    }
                    catch (AlgebricksException ae) {
                        throw new HyracksDataException((Throwable)ae);
                    }
                }
                this.writer.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                for (int t = 0; t < nTuple; ++t) {
                    this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                    try {
                        this.eval.evaluate((IFrameTupleReference)this.tRef, this.p);
                    }
                    catch (AlgebricksException ae) {
                        throw new HyracksDataException((Throwable)ae);
                    }
                    if (!bbi.getBooleanValue(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength())) continue;
                    if (StreamSelectRuntimeFactory.this.projectionList != null) {
                        this.appendProjectionToFrame(t, StreamSelectRuntimeFactory.this.projectionList);
                        continue;
                    }
                    this.appendTupleToFrame(t);
                }
            }
        };
    }
}

