/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.std;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class StreamProjectRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final boolean flushFramesRapidly;

    public StreamProjectRuntimeFactory(int[] projectionList, boolean flushFramesRapidly) {
        super(projectionList);
        this.flushFramesRapidly = flushFramesRapidly;
    }

    public StreamProjectRuntimeFactory(int[] projectionList) {
        this(projectionList, false);
    }

    public String toString() {
        return "stream-project " + Arrays.toString(this.projectionList);
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws AlgebricksException {
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private boolean first = true;

            public void open() throws HyracksDataException {
                if (this.first) {
                    this.first = false;
                    this.initAccessAppend(ctx);
                }
                this.writer.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                int t;
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                if (nTuple > 1) {
                    for (t = 0; t < nTuple - 1; ++t) {
                        this.appendProjectionToFrame(t, StreamProjectRuntimeFactory.this.projectionList);
                    }
                }
                if (StreamProjectRuntimeFactory.this.flushFramesRapidly) {
                    this.appendProjectionToFrame(t, StreamProjectRuntimeFactory.this.projectionList, true);
                } else {
                    this.appendProjectionToFrame(t, StreamProjectRuntimeFactory.this.projectionList);
                }
            }
        };
    }
}

