/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.std;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.data.IBinaryIntegerInspector;
import edu.uci.ics.hyracks.algebricks.data.IBinaryIntegerInspectorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import java.nio.ByteBuffer;

public class StreamLimitRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private IScalarEvaluatorFactory maxObjectsEvalFactory;
    private IScalarEvaluatorFactory offsetEvalFactory;
    private IBinaryIntegerInspectorFactory binaryIntegerInspectorFactory;

    public StreamLimitRuntimeFactory(IScalarEvaluatorFactory maxObjectsEvalFactory, IScalarEvaluatorFactory offsetEvalFactory, int[] projectionList, IBinaryIntegerInspectorFactory binaryIntegerInspectorFactory) {
        super(projectionList);
        this.maxObjectsEvalFactory = maxObjectsEvalFactory;
        this.offsetEvalFactory = offsetEvalFactory;
        this.binaryIntegerInspectorFactory = binaryIntegerInspectorFactory;
    }

    public String toString() {
        String s = "stream-limit " + this.maxObjectsEvalFactory.toString();
        if (this.offsetEvalFactory != null) {
            return s + ", " + this.offsetEvalFactory.toString();
        }
        return s;
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) {
        final IBinaryIntegerInspector bii = this.binaryIntegerInspectorFactory.createBinaryIntegerInspector(ctx);
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private IPointable p = VoidPointable.FACTORY.createPointable();
            private IScalarEvaluator evalMaxObjects;
            private IScalarEvaluator evalOffset = null;
            private int toWrite = 0;
            private int toSkip = 0;
            private boolean firstTuple = true;
            private boolean afterLastTuple = false;

            public void open() throws HyracksDataException {
                if (this.evalMaxObjects == null) {
                    this.initAccessAppendRef(ctx);
                    try {
                        this.evalMaxObjects = StreamLimitRuntimeFactory.this.maxObjectsEvalFactory.createScalarEvaluator(ctx);
                        if (StreamLimitRuntimeFactory.this.offsetEvalFactory != null) {
                            this.evalOffset = StreamLimitRuntimeFactory.this.offsetEvalFactory.createScalarEvaluator(ctx);
                        }
                    }
                    catch (AlgebricksException ae) {
                        throw new HyracksDataException((Throwable)ae);
                    }
                }
                this.writer.open();
                this.afterLastTuple = false;
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                if (this.afterLastTuple) {
                    return;
                }
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                int start = 0;
                if (nTuple <= this.toSkip) {
                    this.toSkip -= nTuple;
                    return;
                }
                if (this.toSkip > 0) {
                    start = this.toSkip;
                    this.toSkip = 0;
                }
                for (int t = start; t < nTuple; ++t) {
                    if (this.firstTuple) {
                        this.firstTuple = false;
                        this.toWrite = this.evaluateInteger(this.evalMaxObjects, t);
                        if (this.evalOffset != null) {
                            this.toSkip = this.evaluateInteger(this.evalOffset, t);
                        }
                    }
                    if (this.toSkip > 0) {
                        --this.toSkip;
                        continue;
                    }
                    if (this.toWrite > 0) {
                        --this.toWrite;
                        if (StreamLimitRuntimeFactory.this.projectionList != null) {
                            this.appendProjectionToFrame(t, StreamLimitRuntimeFactory.this.projectionList);
                            continue;
                        }
                        this.appendTupleToFrame(t);
                        continue;
                    }
                    this.afterLastTuple = true;
                    break;
                }
            }

            @Override
            public void close() throws HyracksDataException {
                super.close();
            }

            private int evaluateInteger(IScalarEvaluator eval, int tIdx) throws HyracksDataException {
                this.tRef.reset((IFrameTupleAccessor)this.tAccess, tIdx);
                try {
                    eval.evaluate((IFrameTupleReference)this.tRef, this.p);
                }
                catch (AlgebricksException ae) {
                    throw new HyracksDataException((Throwable)ae);
                }
                int lim = bii.getIntegerValue(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength());
                return lim;
            }
        };
    }
}

