/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.runtime.operators.std;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.data.IAWriter;
import edu.uci.ics.hyracks.algebricks.data.IAWriterFactory;
import edu.uci.ics.hyracks.algebricks.data.IPrinterFactory;
import edu.uci.ics.hyracks.algebricks.runtime.base.IPushRuntime;
import edu.uci.ics.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import edu.uci.ics.hyracks.algebricks.runtime.operators.std.SinkWriterRuntime;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class SinkWriterRuntimeFactory
implements IPushRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final int[] fields;
    private final IPrinterFactory[] printerFactories;
    private final File outputFile;
    private final RecordDescriptor inputRecordDesc;
    private final IAWriterFactory writerFactory;

    public SinkWriterRuntimeFactory(int[] fields, IPrinterFactory[] printerFactories, File outputFile, IAWriterFactory writerFactory, RecordDescriptor inputRecordDesc) {
        this.fields = fields;
        this.printerFactories = printerFactories;
        this.outputFile = outputFile;
        this.writerFactory = writerFactory;
        this.inputRecordDesc = inputRecordDesc;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("sink-write [");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i > 0) {
                buf.append("; ");
            }
            buf.append(this.fields[i]);
        }
        buf.append("] outputFile");
        return buf.toString();
    }

    @Override
    public IPushRuntime createPushRuntime(IHyracksTaskContext ctx) throws AlgebricksException {
        PrintStream filePrintStream = null;
        try {
            filePrintStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.outputFile)));
        }
        catch (FileNotFoundException e) {
            throw new AlgebricksException((Throwable)e);
        }
        IAWriter w = this.writerFactory.createWriter(this.fields, filePrintStream, this.printerFactories, this.inputRecordDesc);
        return new SinkWriterRuntime(w, ctx, filePrintStream, this.inputRecordDesc, true);
    }
}

